/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.world.gen.WorldGenHunterCamp;
import de.teamlapen.vampirism.world.gen.WorldGenVampireDungeon;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

public class VampirismWorldGen
implements IWorldGenerator {
    public static boolean debug = false;
    private final WorldGenHunterCamp hunterCamp = new WorldGenHunterCamp();
    private final WorldGenVampireDungeon vampireDungeon = new WorldGenVampireDungeon();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int dim = world.field_73011_w.getDimension();
        if (dim == 0 || dim != -1 && dim != 1 && (this.contains(Configs.worldGenDimensions, dim) || VampirismAPI.isWorldGenEnabledFor(dim))) {
            this.generateOverworld(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    public void generateOverworld(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        boolean mapFeatures = world.func_72912_H().func_76089_r();
        if (mapFeatures) {
            Biome biome = world.func_180494_b(new BlockPos((chunkX << 4) + 8, 0, (chunkZ << 4) + 8));
            if (this.hunterCamp.canCampSpawnAt(world, biome, chunkX, chunkZ)) {
                BlockPos pos = new BlockPos(chunkX << 4, 1, chunkZ << 4);
                int tries = 5;
                int max = random.nextInt(3) + 1;
                tries += Math.min(Math.max(biome.field_76760_I.field_76832_z, 0), 5);
                tries = (int)((float)tries + 10.0f * biome.func_185360_m());
                if (Biomes.field_150585_R.equals(biome)) {
                    tries += 4;
                }
                if (debug) {
                    VampirismMod.log.i("WorldGen", "Trying to generate camp at %s with %d tries", pos, tries);
                }
                for (int j = 0; j < max; ++j) {
                    for (int i = 0; i < tries && !this.hunterCamp.func_180709_b(world, random, pos); ++i) {
                    }
                }
            }
            for (int j2 = 0; j2 < 10; ++j2) {
                BlockPos pos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
                int i3 = random.nextInt(16) + 8;
                int l3 = random.nextInt(256);
                int l1 = random.nextInt(16) + 8;
                this.vampireDungeon.func_180709_b(world, random, pos.func_177982_a(i3, l3, l1));
            }
        }
    }

    private boolean contains(int[] array, int value) {
        for (int i : array) {
            if (i != value) continue;
            return true;
        }
        return false;
    }
}

