/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.entity.hunter.EntityAdvancedHunter;
import de.teamlapen.vampirism.items.ItemTent;
import de.teamlapen.vampirism.world.gen.VampirismWorldGen;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fluids.IFluidBlock;

public class WorldGenHunterCamp
extends WorldGenerator {
    private int distance;

    public WorldGenHunterCamp() {
        this.distance = Balance.general.HUNTER_CAMP_DENSITY;
    }

    public boolean canCampSpawnAt(World world, Biome biome, int chunkX, int chunkZ) {
        if (ModBiomes.vampireForest.getRegistryName().equals((Object)biome.getRegistryName())) {
            return false;
        }
        BlockPos pos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
        float t = biome.func_180626_a(pos = world.func_175645_m(pos));
        if (t > 1.5f || t < 0.1f) {
            return false;
        }
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.distance - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.distance - 1;
        }
        int k = chunkX / this.distance;
        int l = chunkZ / this.distance;
        Random random = world.func_72843_D(k, l, 10387312);
        k *= this.distance;
        l *= this.distance;
        if (i == (k += random.nextInt(this.distance - 2)) && j == (l += random.nextInt(this.distance - 2))) {
            return world.func_175714_ae().func_176056_a(new BlockPos(i << 4, 10, j << 4), 20) == null;
        }
        return false;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        if ((double)worldIn.getBiomeForCoordsBody(position).func_185360_m() < 0.3 && rand.nextInt(6) == 0) {
            boolean place;
            int r = rand.nextInt(2);
            int r1 = rand.nextInt(2);
            int r2 = rand.nextInt(2);
            int r3 = rand.nextInt(2);
            BlockPos center = this.findSolidPos(worldIn, position.func_177982_a(8, 0, 8));
            BlockPos pos1 = this.findSolidPos(worldIn, center.func_177982_a(4 + r, 5, r1 - 1));
            BlockPos pos2 = this.findSolidPos(worldIn, center.func_177982_a(-4 - r1, 5, r2 - 1));
            BlockPos pos3 = this.findSolidPos(worldIn, center.func_177982_a(r2 - 1, 5, -4 - r3));
            BlockPos pos4 = this.findSolidPos(worldIn, center.func_177982_a(r3 - 1, 5, 4 + r));
            int dif = Math.abs(center.func_177956_o() - pos1.func_177956_o()) + Math.abs(center.func_177956_o() - pos2.func_177956_o()) + Math.abs(center.func_177956_o() - pos3.func_177956_o()) + Math.abs(center.func_177956_o() - pos4.func_177956_o());
            boolean bl = place = dif < 8 && this.placeFire(worldIn, this.findSolidPos(worldIn, center));
            if (place) {
                this.placeTent(worldIn, rand, pos1, EnumFacing.EAST);
                this.placeTent(worldIn, rand, pos2, EnumFacing.WEST);
                this.placeTent(worldIn, rand, pos3, EnumFacing.NORTH);
                this.placeTent(worldIn, rand, pos4, EnumFacing.SOUTH);
                EntityAdvancedHunter hunter = new EntityAdvancedHunter(worldIn);
                AxisAlignedBB box = new AxisAlignedBB(center.func_177982_a(-7, 0, -7), center.func_177982_a(7, 1, 7));
                UtilLib.spawnEntityInWorld(worldIn, box, (Entity)hunter, 8);
                hunter.setCampArea(box.func_72314_b(3.0, 5.0, 3.0));
                if (VampirismWorldGen.debug) {
                    VampirismMod.log.i("HunterCamp", "Generated advanced hunter camp at %s", center);
                }
                return true;
            }
            return false;
        }
        BlockPos pos = position.func_177982_a(rand.nextInt(16), 0, rand.nextInt(16));
        boolean flag = this.placeTent(worldIn, rand, this.findSolidPos(worldIn, pos), EnumFacing.func_176731_b((int)rand.nextInt(EnumFacing.field_176754_o.length)));
        if (flag && VampirismWorldGen.debug) {
            VampirismMod.log.i("HunterCamp", "Generated normal hunter camp at %s", pos);
        }
        return flag;
    }

    private boolean checkGroundAndPos(World worldIn, BlockPos position, IBlockState ground) {
        if (worldIn.func_180495_p(position).func_185904_a().func_76224_d()) {
            return false;
        }
        IBlockState b = worldIn.func_180495_p(position.func_177977_b());
        if (b.func_185904_a().func_76224_d() || b.func_177230_c() instanceof IFluidBlock) {
            return false;
        }
        if (ground != null && b.func_185904_a().func_76222_j()) {
            worldIn.func_175656_a(position.func_177977_b(), ground);
            return true;
        }
        return worldIn.isSideSolid(position.func_177977_b(), EnumFacing.UP, false);
    }

    private BlockPos findSolidPos(World world, BlockPos position) {
        Material material;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(world.func_175645_m(position).func_177981_b(30));
        while (((material = world.func_180495_p((BlockPos)pos).func_185904_a()) == Material.field_151584_j || material == Material.field_151585_k || world.func_175623_d((BlockPos)pos)) && pos.func_177956_o() > 50) {
            pos.func_189536_c(EnumFacing.DOWN);
        }
        return pos.func_177984_a();
    }

    private boolean placeFire(World worldIn, BlockPos position) {
        if (this.checkGroundAndPos(worldIn, position, null)) {
            this.func_175903_a(worldIn, position, ModBlocks.firePlace.func_176223_P());
            return true;
        }
        return false;
    }

    private boolean placeTent(World worldIn, Random rand, BlockPos position, EnumFacing facing) {
        IBlockState ground = worldIn.func_180495_p(position.func_177977_b());
        if (ground.func_177230_c().isSideSolid(ground, (IBlockAccess)worldIn, position.func_177977_b(), EnumFacing.UP)) {
            BlockPos tl = worldIn.func_175645_m(position.func_177972_a(facing).func_177972_a(facing.func_176735_f()));
            BlockPos bl = worldIn.func_175645_m(position.func_177972_a(facing.func_176735_f()));
            BlockPos tr = worldIn.func_175645_m(position.func_177972_a(facing));
            if (Math.abs(tl.func_177956_o() - position.func_177956_o()) < 2 && Math.abs(bl.func_177956_o() - position.func_177956_o()) < 2 && Math.abs(tr.func_177956_o() - position.func_177956_o()) < 2) {
                tl = new BlockPos(tl.func_177958_n(), position.func_177956_o(), tl.func_177952_p());
                bl = new BlockPos(bl.func_177958_n(), position.func_177956_o(), bl.func_177952_p());
                tr = new BlockPos(tr.func_177958_n(), position.func_177956_o(), tr.func_177952_p());
                if (!this.checkGroundAndPos(worldIn, tl, ground)) {
                    return false;
                }
                if (!this.checkGroundAndPos(worldIn, bl, ground)) {
                    return false;
                }
                if (!this.checkGroundAndPos(worldIn, tr, ground)) {
                    return false;
                }
                ItemTent.placeAt(worldIn, position, facing, true, true);
                BlockPos entrance1 = position.func_177972_a(facing.func_176734_d());
                BlockPos entrance2 = position.func_177972_a(facing.func_176734_d()).func_177972_a(facing.func_176735_f());
                worldIn.func_175698_g(entrance1);
                worldIn.func_175698_g(entrance2);
                if (rand.nextInt(3) == 0) {
                    this.func_175903_a(worldIn, worldIn.func_175645_m(entrance1.func_177972_a(facing.func_176734_d())), Blocks.field_150462_ai.func_176223_P());
                }
                if (rand.nextInt(3) == 0) {
                    this.func_175903_a(worldIn, worldIn.func_175645_m(entrance2.func_177972_a(facing.func_176734_d())), Blocks.field_150478_aa.func_176223_P());
                }
                return true;
            }
        }
        return false;
    }
}

