/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot;

import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.world.loot.AddBookNbt;
import de.teamlapen.vampirism.world.loot.SetItemTier;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LootHandler {
    private static final List<String> INJECTION_TABLES = ImmutableList.of((Object)"inject/abandoned_mineshaft", (Object)"inject/jungle_temple", (Object)"inject/stronghold_corridor", (Object)"inject/desert_pyramid", (Object)"inject/stronghold_library");
    private static final List<String> TABLES = ImmutableList.of((Object)"vampire_dungeon", (Object)"village_trainer");
    private static final LootHandler instance = new LootHandler();
    private int injected = 0;

    public static LootHandler getInstance() {
        return instance;
    }

    private LootHandler() {
        for (String s : INJECTION_TABLES) {
            LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("vampirism", s));
        }
        for (String s : TABLES) {
            LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("vampirism", s));
        }
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new AddBookNbt.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new SetItemTier.Serializer());
    }

    public boolean checkAndResetInsertedAll() {
        int i = this.injected;
        this.injected = 0;
        return i >= INJECTION_TABLES.size();
    }

    @SubscribeEvent
    public void onLootLoad(LootTableLoadEvent event) {
        String prefix = "minecraft:chests/";
        String name = event.getName().toString();
        if (name.startsWith(prefix)) {
            String file;
            switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                case "abandoned_mineshaft": 
                case "desert_pyramid": 
                case "jungle_temple": 
                case "stronghold_corridor": 
                case "stronghold_library": {
                    event.getTable().addPool(this.getInjectPool(file));
                    ++this.injected;
                    break;
                }
            }
        }
    }

    private LootEntryTable getInjectEntry(String name, int weight) {
        return new LootEntryTable(new ResourceLocation("vampirism", "inject/" + name), weight, 0, new LootCondition[0], "vampirism_inject_entry");
    }

    private LootPool getInjectPool(String entryName) {
        return new LootPool(new LootEntry[]{this.getInjectEntry(entryName, 1)}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "vampirism_inject_pool");
    }
}

