/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.villages;

import com.google.common.collect.Lists;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.hunter.IHunter;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.world.IVampirismVillage;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.entity.hunter.EntityBasicHunter;
import de.teamlapen.vampirism.entity.hunter.EntityHunterVillager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.village.Village;
import net.minecraft.world.World;

public class VampirismVillage
implements IVampirismVillage {
    private final String TAG = "VampirismVillage";
    private World world;
    private BlockPos center = new BlockPos(0, 0, 0);
    private int recentlyBitten;
    private int recentlyConverted;
    private boolean agressive;
    private List<VillageAggressorVampire> villageAggressorVampires = Lists.newArrayList();
    private boolean dirty;
    private int recentlyBittenToDeath;
    private int tickCounter;

    private static AxisAlignedBB getBoundingBox(Village v) {
        int r = v.func_75568_b();
        BlockPos cc = v.func_180608_a();
        return new AxisAlignedBB((double)(cc.func_177958_n() - r), (double)(cc.func_177956_o() - 10), (double)(cc.func_177952_p() - r), (double)(cc.func_177958_n() + r), (double)(cc.func_177956_o() + 10), (double)(cc.func_177952_p() + r));
    }

    @Override
    @Nullable
    public IVampire findNearestVillageAggressor(@Nonnull EntityLivingBase entityCenter) {
        double d0 = Double.MAX_VALUE;
        VillageAggressorVampire aggressorVampire = null;
        for (VillageAggressorVampire vampire : this.villageAggressorVampires) {
            double d1 = vampire.aggressorEntity.func_70068_e((Entity)entityCenter);
            if (!(d1 <= d0)) continue;
            aggressorVampire = vampire;
            d0 = d1;
        }
        return aggressorVampire != null ? aggressorVampire.aggressorVampire : null;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return VampirismVillage.getBoundingBox(this.getVillage());
    }

    @Override
    public BlockPos getCenter() {
        return this.center;
    }

    void setCenter(BlockPos cc) {
        this.center = cc;
    }

    @Override
    public Village getVillage() {
        Village v = this.world.field_72982_D.func_176056_a(this.center, 0);
        if (v == null) {
            return null;
        }
        if (!v.func_180608_a().equals((Object)this.center)) {
            return null;
        }
        return v;
    }

    public String makeDebugString(BlockPos pos) {
        Village v = this.getVillage();
        if (v == null) {
            return "MC Village does not exist" + this.getCenter();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Center: ").append(this.getCenter().toString());
        builder.append("\nIs inside: ").append(v.func_179866_a(pos)).append(" (").append(this.getBoundingBox().func_72318_a(new Vec3d((Vec3i)pos))).append(')');
        builder.append("\n").append(String.format("RBitten: %s, RConv: %s, RBDeath: %s, Agrr: %s", this.recentlyBitten, this.recentlyConverted, this.recentlyBittenToDeath, this.agressive));
        List<EntityVillager> allVillagers = this.getAllVillager(v);
        List<EntityBasicHunter> hunters = this.getHunter(v);
        List<EntityHunterVillager> hunterVillagers = this.filterHunterVillagers(allVillagers);
        List<EntityVillager> normalVillager = this.filterNormalVillagers(allVillagers);
        builder.append("\n").append(String.format("Stats: Doors: %s, Aggro: %s, v: %s, vh: %s, h: %s", v.func_75567_c(), this.calculateAggressiveCounter(), normalVillager.size(), hunterVillagers.size(), hunters.size()));
        int hunterCount = hunters.size() + hunterVillagers.size() / 2;
        boolean spawn = (double)hunterCount < Balance.village.MIN_HUNTER_COUNT_VILLAGE_PER_DOOR * (double)v.func_75567_c() + 1.0;
        builder.append("\nShould Spawn: ").append(hunterCount).append('(').append(spawn).append(')');
        builder.append("\nAgressors: ").append(this.villageAggressorVampires.toString());
        return builder.toString();
    }

    @Override
    public void onVillagerBitten(IVampire vampire) {
        ++this.recentlyBitten;
        this.dirty = true;
        this.addOrRenewAggressor(vampire);
    }

    @Override
    public void onVillagerBittenToDeath(IVampire vampire) {
        ++this.recentlyBittenToDeath;
        this.dirty = true;
        this.addOrRenewAggressor(vampire);
    }

    @Override
    public void onVillagerConverted(@Nullable IVampire vampire) {
        ++this.recentlyConverted;
        this.dirty = true;
        if (vampire != null) {
            this.addOrRenewAggressor(vampire);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.center = UtilLib.readPos(nbt, "center");
        this.agressive = nbt.func_74767_n("AGR");
        this.recentlyBitten = nbt.func_74762_e("BITTEN");
        this.recentlyConverted = nbt.func_74762_e("CONVERTED");
        this.recentlyBittenToDeath = nbt.func_74762_e("KILLED");
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public boolean tick(int tickCounter) {
        this.tickCounter = tickCounter;
        if (tickCounter % 20 == 13) {
            int tick = tickCounter / 20;
            this.removeDeadAndOldAggressors();
            Village v = this.getVillage();
            if (v != null) {
                if (tick % Balance.village.REDUCE_RATE == 0) {
                    if (this.recentlyBitten > 0) {
                        --this.recentlyBitten;
                        this.dirty = true;
                    }
                    boolean respawn = false;
                    if (this.recentlyConverted > 0) {
                        --this.recentlyConverted;
                        this.dirty = true;
                        respawn = true;
                    } else if (this.recentlyBittenToDeath > 0) {
                        --this.recentlyBittenToDeath;
                        this.dirty = true;
                        respawn = true;
                    }
                    if (respawn && this.world.field_73012_v.nextInt(Balance.village.VILLAGER_RESPAWN_RATE) == 0) {
                        this.spawnVillager(v);
                    }
                }
                this.world.field_72984_F.func_76320_a("checkVillagersHunters");
                List<EntityVillager> allVillagers = this.getAllVillager(v);
                List<EntityBasicHunter> hunters = this.getHunter(v);
                List<EntityHunterVillager> hunterVillagers = this.filterHunterVillagers(allVillagers);
                List<EntityVillager> normalVillager = this.filterNormalVillagers(allVillagers);
                if (this.world.field_73012_v.nextInt(30) == 0) {
                    boolean spawn;
                    int hunterCount = hunters.size() + hunterVillagers.size() / 2;
                    boolean bl = spawn = (double)hunterCount < Balance.village.MIN_HUNTER_COUNT_VILLAGE_PER_DOOR * (double)v.func_75567_c() + 1.0;
                    if (spawn || this.world.field_73012_v.nextInt(30) == 0) {
                        VampirismMod.log.d("VampirismVillage", "Stats: Doors: %s, Aggro: %s, v: %s, vh: %s, h: %s", v.func_75567_c(), this.calculateAggressiveCounter(), normalVillager.size(), hunterVillagers.size(), hunters.size());
                    }
                    if (spawn && hunterCount > 20) {
                        VampirismMod.log.w("VampirismVillage", "Too many hunters spawning. Canceling", new Object[0]);
                        VampirismMod.log.w("VampirismVillage", "Stats: Doors: %s, Aggro: %s, v: %s, vh: %s, h: %s", v.func_75567_c(), this.calculateAggressiveCounter(), normalVillager.size(), hunterVillagers.size(), hunters.size());
                        VampirismMod.log.w("VampirismVillage", "Hunter Count: %s, Spawn Config: %s", hunterCount, Balance.village.MIN_HUNTER_COUNT_VILLAGE_PER_DOOR);
                        spawn = false;
                    }
                    if (spawn) {
                        this.spawnHunter(v);
                    }
                }
                this.world.field_72984_F.func_76319_b();
                int aggressiveCounter = this.calculateAggressiveCounter();
                if (aggressiveCounter >= Balance.village.AGGRESSIVE_COUNTER_THRESHOLD) {
                    if (!this.agressive) {
                        this.spawnVillager(v);
                        Collections.shuffle(normalVillager);
                        this.makeAgressive(this.selectVillagersToBecomeHunter(normalVillager));
                    }
                } else if (this.agressive && aggressiveCounter < Balance.village.AGGRESSIVE_COUNTER_THRESHOLD / 2 + 1) {
                    this.makeCalm(hunterVillagers);
                }
            }
        }
        if (this.dirty) {
            this.dirty = false;
            return true;
        }
        return false;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        UtilLib.write(nbt, "center", this.center);
        nbt.func_74757_a("AGR", this.agressive);
        nbt.func_74768_a("BITTEN", this.recentlyBitten);
        nbt.func_74768_a("CONVERTED", this.recentlyConverted);
        nbt.func_74768_a("KILLED", this.recentlyBittenToDeath);
    }

    private void addOrRenewAggressor(@Nonnull IVampire vampire) {
        for (VillageAggressorVampire aggressor : this.villageAggressorVampires) {
            if (!aggressor.aggressorVampire.equals(vampire)) continue;
            aggressor.agressionTime = this.tickCounter;
            return;
        }
        this.villageAggressorVampires.add(new VillageAggressorVampire(vampire.getRepresentingEntity(), vampire, this.tickCounter));
    }

    private int calculateAggressiveCounter() {
        return this.recentlyBitten * Balance.village.BITTEN_AGGRESSIVE_FACTOR + this.recentlyBittenToDeath * Balance.village.BITTEN_TO_DEATH_AGGRESSIVE_FACTOR + this.recentlyConverted * Balance.village.CONVERTED_AGGRESSIVE_FACTOR;
    }

    private List<EntityHunterVillager> filterHunterVillagers(List<EntityVillager> all) {
        ArrayList<EntityHunterVillager> filtered = new ArrayList<EntityHunterVillager>();
        for (EntityVillager villager : all) {
            if (!(villager instanceof EntityHunterVillager)) continue;
            filtered.add((EntityHunterVillager)villager);
        }
        return filtered;
    }

    private List<EntityVillager> filterNormalVillagers(List<EntityVillager> all) {
        ArrayList<EntityVillager> filtered = new ArrayList<EntityVillager>();
        for (EntityVillager villager : all) {
            if (villager instanceof IVampire || villager instanceof IHunter) continue;
            filtered.add(villager);
        }
        return filtered;
    }

    private List<EntityVillager> filterVampireVillagers(List<EntityVillager> all) {
        ArrayList<EntityVillager> filtered = new ArrayList<EntityVillager>();
        for (EntityVillager villager : all) {
            if (!(villager instanceof IVampire)) continue;
            filtered.add(villager);
        }
        return filtered;
    }

    private List<EntityVillager> getAllVillager(Village v) {
        return this.world.func_72872_a(EntityVillager.class, VampirismVillage.getBoundingBox(v));
    }

    private List<EntityBasicHunter> getHunter(Village v) {
        return this.world.func_72872_a(EntityBasicHunter.class, VampirismVillage.getBoundingBox(v));
    }

    int isAnnihilated() {
        Village v = this.world.field_72982_D.func_176056_a(this.center, 0);
        if (v == null) {
            VampirismMod.log.i("VampirismVillage", "Can't find village at %s anymore", this.center);
            return -1;
        }
        if (!this.getCenter().equals((Object)v.func_180608_a())) {
            this.setCenter(v.func_180608_a());
            return 0;
        }
        return 1;
    }

    private void makeAgressive(List<EntityVillager> villagers) {
        VampirismMod.log.d("VampirismVillage", "Making villagers aggressive", new Object[0]);
        this.agressive = true;
        this.dirty = true;
        for (EntityVillager v : villagers) {
            EntityHunterVillager hunter = EntityHunterVillager.makeHunter(v);
            v.func_130014_f_().func_72838_d((Entity)hunter);
            v.func_70106_y();
        }
    }

    private void makeCalm(List<EntityHunterVillager> hunters) {
        VampirismMod.log.d("VampirismVillage", "Making villagers calm", new Object[0]);
        for (EntityHunterVillager h : hunters) {
            EntityVillager villager = EntityHunterVillager.makeNormal(h);
            h.func_130014_f_().func_72838_d((Entity)villager);
            h.func_70106_y();
        }
        this.agressive = false;
        this.dirty = true;
    }

    private void removeDeadAndOldAggressors() {
        Iterator<VillageAggressorVampire> iterator = this.villageAggressorVampires.iterator();
        while (iterator.hasNext()) {
            VillageAggressorVampire aggressorVampire = iterator.next();
            if (aggressorVampire.aggressorEntity.func_70089_S() && Math.abs(this.tickCounter - aggressorVampire.agressionTime) <= 600) continue;
            iterator.remove();
        }
    }

    private List<EntityVillager> selectVillagersToBecomeHunter(List<EntityVillager> villagers) {
        LinkedList<EntityVillager> selected = new LinkedList<EntityVillager>();
        for (EntityVillager v : villagers) {
            if (v.func_70631_g_() || !v.func_70089_S() || v.func_70644_a(ModPotions.sanguinare) || v.func_70940_q() || v.func_70941_o() || v.func_70681_au().nextInt(Balance.village.VILLAGER_HUNTER_CHANCE) != 0) continue;
            selected.add(v);
        }
        return selected;
    }

    private void spawnHunter(Village v) {
        EntityBasicHunter hunter = new EntityBasicHunter(this.world);
        boolean flag = UtilLib.spawnEntityInWorld(this.world, VampirismVillage.getBoundingBox(v), (Entity)hunter, 5);
        if (flag) {
            hunter.makeVillageHunter(this);
        } else {
            hunter.func_70106_y();
        }
        VampirismMod.log.t("Spawning Vampire Hunter %s", flag);
    }

    private void spawnVillager(Village v) {
        VampirismMod.log.t("Spawning villager at village %s", v.func_180608_a());
        List l = this.world.func_72872_a(EntityVillager.class, VampirismVillage.getBoundingBox(v));
        if (l.size() > 0) {
            EntityVillager entityvillager;
            EntityVillager ev = (EntityVillager)l.get(this.world.field_73012_v.nextInt(l.size()));
            if (this.agressive && ev.func_70681_au().nextInt(Balance.village.VILLAGER_HUNTER_CHANCE) == 0) {
                EntityVillager temp = new EntityVillager(ev.func_130014_f_());
                entityvillager = EntityHunterVillager.makeHunter(temp);
                temp.func_70106_y();
            } else {
                entityvillager = ev.func_90011_a((EntityAgeable)ev);
                entityvillager.func_70873_a(-24000);
                ev.func_70873_a(6000);
            }
            entityvillager.func_70012_b(ev.field_70165_t, ev.field_70163_u, ev.field_70161_v, 0.0f, 0.0f);
            this.world.func_72838_d((Entity)entityvillager);
            this.world.func_72960_a((Entity)entityvillager, (byte)12);
        }
    }

    private class VillageAggressorVampire {
        final EntityLivingBase aggressorEntity;
        final IVampire aggressorVampire;
        int agressionTime;

        private VillageAggressorVampire(EntityLivingBase aggressorEntity, IVampire aggressorVampire, int agressionTime) {
            this.aggressorEntity = aggressorEntity;
            this.aggressorVampire = aggressorVampire;
            this.agressionTime = agressionTime;
        }

        public String toString() {
            return "VillageAggressorVampire{aggressorEntity=" + this.aggressorEntity + ", agressionTime=" + this.agressionTime + '}';
        }
    }
}

