/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.villages;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.world.IVampirismVillageProvider;
import de.teamlapen.vampirism.world.villages.VampirismVillage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSavedData;

public class VampirismVillageCollection
extends WorldSavedData
implements IVampirismVillageProvider {
    private static final String IDENTIFIER = "vampirism_villages";
    private final List<VampirismVillage> villageList = new ArrayList<VampirismVillage>();
    private World worldObj;
    private int tickCounter;

    public static VampirismVillageCollection get(World world) {
        String s = VampirismVillageCollection.fileNameForProvider(world.field_73011_w);
        VampirismVillageCollection data = (VampirismVillageCollection)world.getPerWorldStorage().func_75742_a(VampirismVillageCollection.class, s);
        if (data == null) {
            data = new VampirismVillageCollection(world);
            world.getPerWorldStorage().func_75745_a(s, (WorldSavedData)data);
        } else {
            data.setWorldsForAll(world);
        }
        return data;
    }

    private static String fileNameForProvider(WorldProvider provider) {
        return IDENTIFIER + provider.func_186058_p().func_186067_c();
    }

    public VampirismVillageCollection(String name) {
        super(name);
    }

    private VampirismVillageCollection(World world) {
        this(VampirismVillageCollection.fileNameForProvider(world.field_73011_w));
        this.worldObj = world;
        this.func_76185_a();
    }

    @Override
    @Nullable
    public VampirismVillage getNearestVillage(Entity e) {
        return this.getNearestVillage(e.func_180425_c(), 10);
    }

    @Override
    @Nullable
    public VampirismVillage getNearestVillage(BlockPos pos, int r) {
        Village v = this.worldObj.field_72982_D.func_176056_a(pos, r);
        if (v == null) {
            return null;
        }
        return this.getVampirismVillage(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public VampirismVillage getVampirismVillage(Village v) {
        List<VampirismVillage> list = this.villageList;
        synchronized (list) {
            for (VampirismVillage vv : this.villageList) {
                if (!vv.getCenter().equals((Object)v.func_180608_a())) continue;
                return vv;
            }
            VampirismVillage vv = new VampirismVillage();
            vv.setWorld(this.worldObj);
            vv.setCenter(v.func_180608_a());
            VampirismMod.log.d("VampirismVillages", "Created village at " + v.func_180608_a(), new Object[0]);
            this.villageList.add(vv);
            this.func_76185_a();
            return vv;
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.tickCounter = nbt.func_74762_e("Tick");
        NBTTagList nbttaglist = nbt.func_150295_c("Villages", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            VampirismVillage village = new VampirismVillage();
            village.readFromNBT(nbttagcompound1);
            this.villageList.add(village);
        }
    }

    public void tick() {
        if (this.worldObj == null || this.worldObj.field_72982_D == null) {
            return;
        }
        ++this.tickCounter;
        boolean dirty = false;
        this.worldObj.field_72984_F.func_76320_a("vampirism_vampireVillages_checkAnnihilated");
        this.checkForAnnihilatedVillages();
        this.worldObj.field_72984_F.func_76318_c("vampirism_vampireVillages_tick");
        for (VampirismVillage v : this.villageList) {
            if (!v.tick(this.tickCounter)) continue;
            dirty = true;
        }
        this.worldObj.field_72984_F.func_76319_b();
        if (dirty) {
            this.func_76185_a();
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        nbt.func_74768_a("Tick", this.tickCounter);
        NBTTagList nbttaglist = new NBTTagList();
        for (VampirismVillage village : this.villageList) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            village.writeToNBT(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Villages", (NBTBase)nbttaglist);
        return nbt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForAnnihilatedVillages() {
        List<VampirismVillage> list = this.villageList;
        synchronized (list) {
            Iterator<VampirismVillage> iterator = this.villageList.iterator();
            while (iterator.hasNext()) {
                VampirismVillage v = iterator.next();
                switch (v.isAnnihilated()) {
                    case -1: {
                        VampirismMod.log.d("VampirismVillages", "Removing annihilated village at %s", v.getCenter());
                        iterator.remove();
                        this.func_76185_a();
                        break;
                    }
                    case 0: {
                        this.func_76185_a();
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWorldsForAll(World world) {
        this.worldObj = world;
        List<VampirismVillage> list = this.villageList;
        synchronized (list) {
            for (VampirismVillage vv : this.villageList) {
                vv.setWorld(world);
            }
        }
    }
}

