/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.mjrlegendslib.util;

import com.mjr.mjrlegendslib.block.BlockTuple;
import com.mjr.mjrlegendslib.util.MessageUtilities;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BlockUtilities {
    public static ItemStack stringToItemStack(String s, String caller, boolean logging) {
        BlockTuple tuple = BlockUtilities.stringToBlock(s, caller, logging);
        return new ItemStack(tuple.block, 1, tuple.meta);
    }

    public static BlockTuple stringToBlock(String s, String caller, boolean logging) {
        String name;
        Block block;
        int lastColon = s.lastIndexOf(58);
        int meta = -1;
        if (lastColon > 0) {
            try {
                meta = Integer.parseInt(s.substring(lastColon + 1, s.length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((block = Block.func_149684_b((String)(name = meta == -1 ? s : s.substring(0, lastColon)))) == null) {
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(name));
            if (item instanceof ItemBlock) {
                block = ((ItemBlock)item).field_150939_a;
            }
            if (block == null) {
                if (logging) {
                    MessageUtilities.infoMessageToLog("mjrlegendslib", caller + ": unrecognised block name '" + s + "'.");
                }
                return null;
            }
        }
        try {
            Integer.parseInt(name);
            String bName = GameData.getBlockRegistry().getNameForObject((IForgeRegistryEntry)block).toString();
            if (logging) {
                MessageUtilities.infoMessageToLog("mjrlegendslib", caller + ": the use of numeric IDs is discouraged, please use " + bName + " instead of " + name);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (Blocks.field_150350_a == block) {
            if (logging) {
                MessageUtilities.infoMessageToLog("mjrlegendslib", caller + ": not a good idea to specify air, skipping that!");
            }
            return null;
        }
        return new BlockTuple(block, meta);
    }
}

