/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.mjrlegendslib.util;

import com.google.common.collect.ObjectArrays;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;

public class RegisterUtilities {
    private static int id = 0;

    public static void registerBlock(String modID, Block block, String name) {
        GameRegistry.register((IForgeRegistryEntry)block.setRegistryName(modID, name));
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock(block).setRegistryName(modID, name));
    }

    public static void registerBlock(String modID, Block block, Class<? extends ItemBlock> itemclass, String name) throws NoSuchMethodException {
        Object[] itemCtorArgs = new Object[]{};
        ItemBlock i = null;
        if (itemclass != null) {
            Class[] ctorArgClasses = new Class[itemCtorArgs.length + 1];
            ctorArgClasses[0] = Block.class;
            for (int idx = 1; idx < ctorArgClasses.length; ++idx) {
                ctorArgClasses[idx] = itemCtorArgs[idx - 1].getClass();
            }
            Constructor<? extends ItemBlock> itemCtor = itemclass.getConstructor(ctorArgClasses);
            try {
                i = itemCtor.newInstance(ObjectArrays.concat((Object)block, (Object[])itemCtorArgs));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        GameRegistry.register((IForgeRegistryEntry)block.setRegistryName(modID, name));
        GameRegistry.register((IForgeRegistryEntry)i.setRegistryName(modID, name));
    }

    public static void registerItem(Item item) {
        GameRegistry.register((IForgeRegistryEntry)item);
    }

    public static void registerItem(Item item, String name) {
        GameRegistry.register((IForgeRegistryEntry)item.setRegistryName(name));
    }

    public static void registerNonMobEntity(Object mod, Class<? extends Entity> var0, String var1, int trackingDistance, int updateFreq, boolean sendVel) {
        EntityRegistry.registerModEntity(var0, (String)var1, (int)id++, (Object)mod, (int)trackingDistance, (int)updateFreq, (boolean)sendVel);
    }

    public static void registerMobEntity(Object mod, Class<? extends Entity> entityClass, String name, int back, int fore) {
        RegisterUtilities.registerNonMobEntity(mod, entityClass, name, 80, 3, true);
        EntityRegistry.registerEgg(entityClass, (int)back, (int)fore);
    }

    public static void setHarvestLevel(Block block, String toolClass, int level, int meta) {
        block.setHarvestLevel(toolClass, level, block.func_176203_a(meta));
    }

    public static void setHarvestLevel(Block block, String toolClass, int level, IBlockState state) {
        block.setHarvestLevel(toolClass, level, state);
    }

    public static void registerTileEntity(Class<? extends TileEntity> tileEntityClass, String name) {
        GameRegistry.registerTileEntity(tileEntityClass, (String)name);
    }

    public static void registerOre(String name, Item ore) {
        RegisterUtilities.registerOre(name, new ItemStack(ore));
    }

    public static void registerOre(String name, Block ore) {
        RegisterUtilities.registerOre(name, new ItemStack(ore));
    }

    public static void registerOre(String name, @Nonnull ItemStack ore) {
        OreDictionary.registerOre((String)name, (ItemStack)ore);
    }

    public static void registerEventHandler(Object handler) {
        MinecraftForge.EVENT_BUS.register(handler);
    }

    public static void registerWorldGenerator(IWorldGenerator generator, int modGenerationWeight) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)generator, (int)modGenerationWeight);
    }

    public static void registerWorldGenerator(IWorldGenerator generator) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)generator, (int)0);
    }

    public static void setFireBurn(Block block, int encouragement, int flammibility) {
        Blocks.field_150480_ab.func_180686_a(block, encouragement, flammibility);
    }

    public static void registerEntityPlacement(Class<? extends Entity> entity, EntityLiving.SpawnPlacementType type) {
        EntitySpawnPlacementRegistry.setPlacementType(entity, (EntityLiving.SpawnPlacementType)type);
    }

    public static void registerEndermanCarriable(Block block) {
        EntityEnderman.setCarriable((Block)block, (boolean)true);
    }

    public void registerProjectileDispense(Item item, IBehaviorDispenseItem projectile) {
        BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)projectile);
    }

    public static void registerForgeBucket(Fluid fluid) {
        FluidRegistry.addBucketForFluid((Fluid)fluid);
    }

    public SoundEvent registerRecord(String modID, String name) {
        return this.registerSound(new ResourceLocation(modID, "record." + name));
    }

    public SoundEvent registerSound(ResourceLocation location) {
        SoundEvent event = (SoundEvent)new SoundEvent(location).setRegistryName(location);
        GameRegistry.register((IForgeRegistryEntry)event);
        return event;
    }

    public static void registerEnchantment(Enchantment enchantment, String registryName) {
        GameRegistry.register((IForgeRegistryEntry)enchantment.setRegistryName(registryName));
    }

    public static void registerPotion(Potion potion, String registryName) {
        GameRegistry.register((IForgeRegistryEntry)potion.setRegistryName(registryName));
    }

    public static void registerPotionTypes(PotionType potionType, String registryName) {
        GameRegistry.register((IForgeRegistryEntry)potionType.setRegistryName(registryName));
    }

    public static void registerBiome(int id, String name, Biome biome) {
        Biome.func_185354_a((int)id, (String)name, (Biome)biome);
    }

    public static void registerBiomeTypes(Biome biome, BiomeDictionary.Type ... types) {
        BiomeDictionary.registerBiomeType((Biome)biome, (BiomeDictionary.Type[])types);
    }
}

