/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.mjrlegendslib.world;

import com.mjr.mjrlegendslib.world.ChunkProviderBase;
import com.mjr.mjrlegendslib.world.gen.MapGenBaseMeta;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public abstract class ChunkProviderMultiBiomeNormal
extends ChunkProviderBase {
    private Random rand;
    protected World worldObj;
    private double[] depthBuffer = new double[256];
    private Biome[] biomesForGeneration;
    private NoiseGeneratorOctaves minLimitPerlinNoise;
    private NoiseGeneratorOctaves maxLimitPerlinNoise;
    private NoiseGeneratorOctaves mainPerlinNoise;
    private NoiseGeneratorPerlin surfaceNoise;
    public NoiseGeneratorOctaves scaleNoise;
    public NoiseGeneratorOctaves depthNoise;
    public NoiseGeneratorOctaves forestNoise;
    private double[] terrainCalcs;
    private float[] biomeWeights;
    double[] mainNoiseRegion;
    double[] minLimitRegion;
    double[] maxLimitRegion;
    double[] depthRegion;
    protected static IBlockState stoneBlock;
    protected static IBlockState waterBlock;
    private List<MapGenBaseMeta> worldGenerators;

    public ChunkProviderMultiBiomeNormal(World world, long seed, boolean flag) {
        this.worldObj = world;
        this.rand = new Random(seed);
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.surfaceNoise = new NoiseGeneratorPerlin(this.rand, 4);
        this.scaleNoise = new NoiseGeneratorOctaves(this.rand, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.forestNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.terrainCalcs = new double[825];
        this.biomeWeights = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.biomeWeights[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.setBlocksInChunk(chunkX, chunkZ, chunkprimer);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16, chunkZ * 16, 16, 16);
        this.replaceBlocksForBiome(chunkX, chunkZ, chunkprimer, this.biomesForGeneration);
        if (this.worldGenerators == null) {
            this.worldGenerators = this.getWorldGenerators();
        }
        for (MapGenBaseMeta generator : this.worldGenerators) {
            generator.generate(this.worldObj, chunkX, chunkZ, chunkprimer);
        }
        this.onChunkProvide(chunkX, chunkZ, chunkprimer);
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, chunkX, chunkZ);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void setBlocksInChunk(int p_180518_1_, int p_180518_2_, ChunkPrimer p_180518_3_) {
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, p_180518_1_ * 4 - 2, p_180518_2_ * 4 - 2, 10, 10);
        this.generateHeightMap(p_180518_1_ * 4, 0, p_180518_2_ * 4);
        for (int i = 0; i < 4; ++i) {
            int j = i * 5;
            int k = (i + 1) * 5;
            for (int l = 0; l < 4; ++l) {
                int i1 = (j + l) * 33;
                int j1 = (j + l + 1) * 33;
                int k1 = (k + l) * 33;
                int l1 = (k + l + 1) * 33;
                for (int i2 = 0; i2 < 32; ++i2) {
                    double d0 = 0.125;
                    double d1 = this.terrainCalcs[i1 + i2];
                    double d2 = this.terrainCalcs[j1 + i2];
                    double d3 = this.terrainCalcs[k1 + i2];
                    double d4 = this.terrainCalcs[l1 + i2];
                    double d5 = (this.terrainCalcs[i1 + i2 + 1] - d1) * d0;
                    double d6 = (this.terrainCalcs[j1 + i2 + 1] - d2) * d0;
                    double d7 = (this.terrainCalcs[k1 + i2 + 1] - d3) * d0;
                    double d8 = (this.terrainCalcs[l1 + i2 + 1] - d4) * d0;
                    for (int j2 = 0; j2 < 8; ++j2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int k2 = 0; k2 < 4; ++k2) {
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * d14;
                            double lvt_45_1_ = d10 - d16;
                            for (int l2 = 0; l2 < 4; ++l2) {
                                double d;
                                lvt_45_1_ += d16;
                                if (d > 0.0) {
                                    p_180518_3_.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, stoneBlock);
                                    continue;
                                }
                                if (i2 * 8 + j2 >= 63) continue;
                                p_180518_3_.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, waterBlock);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private void generateHeightMap(int chunkX, int chunkY, int chunkZ) {
        this.depthRegion = this.depthNoise.func_76305_a(this.depthRegion, chunkX, chunkZ, 5, 5, 200.0, 200.0, 0.5);
        float f = 684.412f;
        float f1 = 684.412f;
        this.mainNoiseRegion = this.mainPerlinNoise.func_76304_a(this.mainNoiseRegion, chunkX, chunkY, chunkZ, 5, 33, 5, (double)(f / 80.0f), (double)(f1 / 160.0f), (double)(f / 80.0f));
        this.minLimitRegion = this.minLimitPerlinNoise.func_76304_a(this.minLimitRegion, chunkX, chunkY, chunkZ, 5, 33, 5, (double)f, (double)f1, (double)f);
        this.maxLimitRegion = this.maxLimitPerlinNoise.func_76304_a(this.maxLimitRegion, chunkX, chunkY, chunkZ, 5, 33, 5, (double)f, (double)f1, (double)f);
        chunkZ = 0;
        chunkX = 0;
        int i = 0;
        int j = 0;
        for (int k = 0; k < 5; ++k) {
            for (int l = 0; l < 5; ++l) {
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                int i1 = 2;
                Biome biomegenbase = this.biomesForGeneration[k + 2 + (l + 2) * 10];
                for (int j1 = -i1; j1 <= i1; ++j1) {
                    for (int k1 = -i1; k1 <= i1; ++k1) {
                        Biome biomegenbase1 = this.biomesForGeneration[k + j1 + 2 + (l + k1 + 2) * 10];
                        float f5 = 0.0f + biomegenbase1.func_185355_j() * 1.0f;
                        float f6 = 0.0f + biomegenbase1.func_185360_m() * 1.0f;
                        float f7 = this.biomeWeights[j1 + 2 + (k1 + 2) * 5] / (f5 + 2.0f);
                        if (biomegenbase1.func_185355_j() > biomegenbase.func_185355_j()) {
                            f7 /= 2.0f;
                        }
                        f2 += f6 * f7;
                        f3 += f5 * f7;
                        f4 += f7;
                    }
                }
                f2 /= f4;
                f3 /= f4;
                f2 = f2 * 0.9f + 0.1f;
                f3 = (f3 * 4.0f - 1.0f) / 8.0f;
                double d7 = this.depthRegion[j] / 8000.0;
                if (d7 < 0.0) {
                    d7 = -d7 * 0.3;
                }
                if ((d7 = d7 * 3.0 - 2.0) < 0.0) {
                    if ((d7 /= 2.0) < -1.0) {
                        d7 = -1.0;
                    }
                    d7 /= 1.4;
                    d7 /= 2.0;
                } else {
                    if (d7 > 1.0) {
                        d7 = 1.0;
                    }
                    d7 /= 8.0;
                }
                ++j;
                double d8 = f3;
                double d9 = f2;
                d8 += d7 * 0.2;
                d8 = d8 * 8.5 / 8.0;
                double d0 = 8.5 + d8 * 4.0;
                for (int l1 = 0; l1 < 33; ++l1) {
                    double d1 = ((double)l1 - d0) * 12.0 * 128.0 / 256.0 / d9;
                    if (d1 < 0.0) {
                        d1 *= 4.0;
                    }
                    double d2 = this.minLimitRegion[i] / 512.0;
                    double d3 = this.maxLimitRegion[i] / 512.0;
                    double d4 = (this.mainNoiseRegion[i] / 10.0 + 1.0) / 2.0;
                    double d5 = MathHelper.func_151238_b((double)d2, (double)d3, (double)d4) - d1;
                    if (l1 > 29) {
                        double d6 = (float)(l1 - 29) / 3.0f;
                        d5 = d5 * (1.0 - d6) + -10.0 * d6;
                    }
                    this.terrainCalcs[i] = d5;
                    ++i;
                }
            }
        }
    }

    public void replaceBlocksForBiome(int chunkX, int chunkZ, ChunkPrimer chunk, Biome[] biomeGen) {
        double d0 = 0.03125;
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                Biome biomegenbase = biomeGen[x + z * 16];
                biomegenbase.func_180622_a(this.worldObj, this.rand, chunk, chunkX * 16 + z, chunkZ * 16 + x, this.depthBuffer[x + z * 16]);
            }
        }
    }

    public Chunk loadChunk(int x, int z) {
        return this.func_185932_a(x, z);
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        BlockFalling.field_149832_M = true;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        BlockPos pos = new BlockPos(x, 0, z);
        Biome biome = this.worldObj.func_180494_b(pos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.worldObj.func_72905_C());
        long var7 = this.rand.nextLong() / 2L * 2L + 1L;
        long var9 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * var7 + (long)chunkZ * var9 ^ this.worldObj.func_72905_C());
        biome.func_180624_a(this.worldObj, this.rand, pos);
        this.decoratePlanet(this.worldObj, this.rand, x, z);
        WorldEntitySpawner.func_77191_a((World)this.worldObj, (Biome)biome, (int)(x + 8), (int)(z + 8), (int)16, (int)16, (Random)this.rand);
        BlockFalling.field_149832_M = false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biomegenbase = this.worldObj.func_180494_b(pos);
        return biomegenbase.func_76747_a(creatureType);
    }

    public abstract void func_180514_a(Chunk var1, int var2, int var3);

    protected abstract void decoratePlanet(World var1, Random var2, int var3, int var4);

    protected abstract List<MapGenBaseMeta> getWorldGenerators();

    protected abstract void onChunkProvide(int var1, int var2, ChunkPrimer var3);
}

