/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.blocks.LazyBlock;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.ForgeEntity;
import com.sk89q.worldedit.forge.ForgeWorldData;
import com.sk89q.worldedit.forge.ForgeWorldEdit;
import com.sk89q.worldedit.forge.NBTConverter;
import com.sk89q.worldedit.forge.TileEntityBaseBlock;
import com.sk89q.worldedit.forge.TileEntityUtils;
import com.sk89q.worldedit.forge.WorldEditFakePlayer;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.world.AbstractWorld;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.registry.WorldData;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;

public class ForgeWorld
extends AbstractWorld {
    private static final Random random = new Random();
    private static final int UPDATE = 1;
    private static final int NOTIFY = 2;
    private static final int NOTIFY_CLIENT = 4;
    private static final Logger logger = Logger.getLogger(ForgeWorld.class.getCanonicalName());
    private static final IBlockState JUNGLE_LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
    private static final IBlockState JUNGLE_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private static final IBlockState JUNGLE_SHRUB = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private final WeakReference<World> worldRef;

    ForgeWorld(World world) {
        Preconditions.checkNotNull((Object)world);
        this.worldRef = new WeakReference<World>(world);
    }

    public World getWorldChecked() throws WorldEditException {
        World world = (World)this.worldRef.get();
        if (world != null) {
            return world;
        }
        throw new WorldReferenceLostException("The reference to the world was lost (i.e. the world may have been unloaded)");
    }

    public World getWorld() {
        World world = (World)this.worldRef.get();
        if (world != null) {
            return world;
        }
        throw new RuntimeException("The reference to the world was lost (i.e. the world may have been unloaded)");
    }

    @Override
    public String getName() {
        return this.getWorld().func_72912_H().func_76065_j();
    }

    @Override
    public boolean setBlock(Vector position, BaseBlock block, boolean notifyAndLight) throws WorldEditException {
        boolean successful;
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)block);
        World world = this.getWorldChecked();
        int x = position.getBlockX();
        int y = position.getBlockY();
        int z = position.getBlockZ();
        Chunk chunk = world.func_72964_e(x >> 4, z >> 4);
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState old = chunk.func_177435_g(pos);
        IBlockState newState = Block.func_149729_e((int)block.getId()).func_176203_a(block.getData());
        IBlockState successState = chunk.func_177436_a(pos, newState);
        boolean bl = successful = successState != null;
        if (successful && block.hasNbtData()) {
            world.func_175713_t(pos);
            NBTTagCompound nativeTag = NBTConverter.toNative(block.getNbtData());
            nativeTag.func_74778_a("id", block.getNbtId());
            TileEntityUtils.setTileEntity(world, position, nativeTag);
        }
        if (notifyAndLight) {
            if (!successful) {
                newState = old;
            }
            world.func_175664_x(pos);
            world.markAndNotifyBlock(pos, chunk, old, newState, 3);
        }
        return successful;
    }

    @Override
    public int getBlockLightLevel(Vector position) {
        Preconditions.checkNotNull((Object)position);
        return this.getWorld().func_175699_k(new BlockPos(position.getBlockX(), position.getBlockY(), position.getBlockZ()));
    }

    @Override
    public boolean clearContainerBlockContents(Vector position) {
        Preconditions.checkNotNull((Object)position);
        TileEntity tile = this.getWorld().func_175625_s(new BlockPos(position.getBlockX(), position.getBlockY(), position.getBlockZ()));
        if (tile instanceof IInventory) {
            IInventory inv = (IInventory)tile;
            int size = inv.func_70302_i_();
            for (int i = 0; i < size; ++i) {
                inv.func_70299_a(i, null);
            }
            return true;
        }
        return false;
    }

    @Override
    public BaseBiome getBiome(Vector2D position) {
        Preconditions.checkNotNull((Object)position);
        return new BaseBiome(Biome.func_185362_a((Biome)this.getWorld().getBiomeForCoordsBody(new BlockPos(position.getBlockX(), 0, position.getBlockZ()))));
    }

    @Override
    public boolean setBiome(Vector2D position, BaseBiome biome) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)biome);
        Chunk chunk = this.getWorld().func_175726_f(new BlockPos(position.getBlockX(), 0, position.getBlockZ()));
        if (chunk != null && chunk.func_177410_o()) {
            chunk.func_76605_m()[(position.getBlockZ() & 0xF) << 4 | position.getBlockX() & 0xF] = (byte)biome.getId();
            return true;
        }
        return false;
    }

    @Override
    public boolean useItem(Vector position, BaseItem item, Direction face) {
        World world;
        Item nativeItem = Item.func_150899_d((int)item.getType());
        ItemStack stack = new ItemStack(nativeItem, 1, (int)item.getData());
        EnumActionResult used = stack.func_179546_a((EntityPlayer)new WorldEditFakePlayer((WorldServer)(world = this.getWorld())), world, ForgeAdapter.toBlockPos(position), EnumHand.MAIN_HAND, ForgeAdapter.adapt(face), 0.0f, 0.0f, 0.0f);
        return used != EnumActionResult.FAIL;
    }

    @Override
    public void dropItem(Vector position, BaseItemStack item) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)item);
        if (item.getType() == 0) {
            return;
        }
        EntityItem entity = new EntityItem(this.getWorld(), position.getX(), position.getY(), position.getZ(), ForgeWorldEdit.toForgeItemStack(item));
        entity.func_174867_a(10);
        this.getWorld().func_72838_d((Entity)entity);
    }

    @Override
    public boolean regenerate(Region region, EditSession editSession) {
        IChunkProvider provider = this.getWorld().func_72863_F();
        if (!(provider instanceof ChunkProviderServer)) {
            return false;
        }
        BaseBlock[] history = new BaseBlock[256 * (this.getMaxY() + 1)];
        for (Vector2D chunk : region.getChunks()) {
            Vector min = new Vector(chunk.getBlockX() * 16, 0, chunk.getBlockZ() * 16);
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < this.getMaxY() + 1; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        Vector pt = min.add(x, y, z);
                        int index = y * 16 * 16 + z * 16 + x;
                        history[index] = editSession.getBlock(pt);
                    }
                }
            }
            PlayerChunkMap playerManager = ((WorldServer)this.getWorld()).func_184164_w();
            List oldWatchers = null;
            Chunk mcChunk = null;
            try {
                ChunkProviderServer chunkServer = (ChunkProviderServer)provider;
                IChunkGenerator gen = chunkServer.field_186029_c;
                long pos = ChunkPos.func_77272_a((int)chunk.getBlockX(), (int)chunk.getBlockZ());
                if (chunkServer.func_73149_a(chunk.getBlockX(), chunk.getBlockZ())) {
                    mcChunk = chunkServer.func_186028_c(chunk.getBlockX(), chunk.getBlockZ());
                    PlayerChunkMapEntry entry = playerManager.func_187301_b(chunk.getBlockX(), chunk.getBlockZ());
                    if (entry != null) {
                        oldWatchers = entry.field_187283_c;
                        playerManager.func_187305_b(entry);
                    }
                    mcChunk.func_76623_d();
                }
                chunkServer.field_73248_b.remove(pos);
                chunkServer.field_73244_f.remove(pos);
                mcChunk = gen.func_185932_a(chunk.getBlockX(), chunk.getBlockZ());
                chunkServer.field_73244_f.put(pos, (Object)mcChunk);
                if (mcChunk != null) {
                    mcChunk.func_76631_c();
                    mcChunk.func_186030_a((IChunkProvider)chunkServer, chunkServer.field_186029_c);
                }
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Failed to generate chunk", t);
                return false;
            }
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < this.getMaxY() + 1; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        Vector pt = min.add(x, y, z);
                        int index = y * 16 * 16 + z * 16 + x;
                        if (!region.contains(pt)) {
                            editSession.smartSetBlock(pt, history[index]);
                            continue;
                        }
                        editSession.rememberChange(pt, history[index], editSession.rawGetBlock(pt));
                    }
                }
            }
            if (oldWatchers == null) continue;
            for (EntityPlayerMP player : oldWatchers) {
                playerManager.func_72683_a(player);
            }
        }
        return false;
    }

    @Nullable
    private static WorldGenerator createWorldGenerator(TreeGenerator.TreeType type) {
        switch (type) {
            case TREE: {
                return new WorldGenTrees(true);
            }
            case BIG_TREE: {
                return new WorldGenBigTree(true);
            }
            case REDWOOD: {
                return new WorldGenTaiga2(true);
            }
            case TALL_REDWOOD: {
                return new WorldGenTaiga1();
            }
            case BIRCH: {
                return new WorldGenBirchTree(true, false);
            }
            case JUNGLE: {
                return new WorldGenMegaJungle(true, 10, 20, JUNGLE_LOG, JUNGLE_LEAF);
            }
            case SMALL_JUNGLE: {
                return new WorldGenTrees(true, 4 + random.nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, false);
            }
            case SHORT_JUNGLE: {
                return new WorldGenTrees(true, 4 + random.nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, true);
            }
            case JUNGLE_BUSH: {
                return new WorldGenShrub(JUNGLE_LOG, JUNGLE_SHRUB);
            }
            case RED_MUSHROOM: {
                return new WorldGenBigMushroom(Blocks.field_150420_aW);
            }
            case BROWN_MUSHROOM: {
                return new WorldGenBigMushroom(Blocks.field_150419_aX);
            }
            case SWAMP: {
                return new WorldGenSwamp();
            }
            case ACACIA: {
                return new WorldGenSavannaTree(true);
            }
            case DARK_OAK: {
                return new WorldGenCanopyTree(true);
            }
            case MEGA_REDWOOD: {
                return new WorldGenMegaPineTree(false, random.nextBoolean());
            }
            case TALL_BIRCH: {
                return new WorldGenBirchTree(true, true);
            }
        }
        return null;
    }

    @Override
    public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, Vector position) throws MaxChangedBlocksException {
        WorldGenerator generator = ForgeWorld.createWorldGenerator(type);
        return generator != null ? generator.func_180709_b(this.getWorld(), random, ForgeAdapter.toBlockPos(position)) : false;
    }

    @Override
    public WorldData getWorldData() {
        return ForgeWorldData.getInstance();
    }

    @Override
    public boolean isValidBlockType(int id) {
        Block block = Block.func_149729_e((int)id);
        return Block.func_149682_b((Block)block) == id;
    }

    @Override
    public BaseBlock getBlock(Vector position) {
        World world = this.getWorld();
        BlockPos pos = new BlockPos(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        IBlockState state = world.func_180495_p(pos);
        TileEntity tile = this.getWorld().func_175625_s(pos);
        if (tile != null) {
            return new TileEntityBaseBlock(Block.func_149682_b((Block)state.func_177230_c()), state.func_177230_c().func_176201_c(state), tile);
        }
        return new BaseBlock(Block.func_149682_b((Block)state.func_177230_c()), state.func_177230_c().func_176201_c(state));
    }

    @Override
    public BaseBlock getLazyBlock(Vector position) {
        World world = this.getWorld();
        BlockPos pos = new BlockPos(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        IBlockState state = world.func_180495_p(pos);
        return new LazyBlock(Block.func_149682_b((Block)state.func_177230_c()), state.func_177230_c().func_176201_c(state), this, position);
    }

    @Override
    public int hashCode() {
        return this.getWorld().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ForgeWorld) {
            ForgeWorld other = (ForgeWorld)o;
            World otherWorld = (World)other.worldRef.get();
            World thisWorld = (World)this.worldRef.get();
            return otherWorld != null && thisWorld != null && otherWorld.equals(thisWorld);
        }
        if (o instanceof com.sk89q.worldedit.world.World) {
            return ((com.sk89q.worldedit.world.World)o).getName().equals(this.getName());
        }
        return false;
    }

    @Override
    public List<? extends com.sk89q.worldedit.entity.Entity> getEntities(Region region) {
        ArrayList<ForgeEntity> entities = new ArrayList<ForgeEntity>();
        for (Entity entity : this.getWorld().field_72996_f) {
            if (!region.contains(new Vector(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v))) continue;
            entities.add(new ForgeEntity(entity));
        }
        return entities;
    }

    @Override
    public List<? extends com.sk89q.worldedit.entity.Entity> getEntities() {
        ArrayList<ForgeEntity> entities = new ArrayList<ForgeEntity>();
        for (Entity entity : this.getWorld().field_72996_f) {
            entities.add(new ForgeEntity(entity));
        }
        return entities;
    }

    @Override
    @Nullable
    public com.sk89q.worldedit.entity.Entity createEntity(Location location, BaseEntity entity) {
        World world = this.getWorld();
        Entity createdEntity = EntityList.func_75620_a((String)entity.getTypeId(), (World)world);
        if (createdEntity != null) {
            CompoundTag nativeTag = entity.getNbtData();
            if (nativeTag != null) {
                NBTTagCompound tag = NBTConverter.toNative(entity.getNbtData());
                for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                    tag.func_82580_o(name);
                }
                createdEntity.func_70020_e(tag);
            }
            createdEntity.func_70012_b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            world.func_72838_d(createdEntity);
            return new ForgeEntity(createdEntity);
        }
        return null;
    }

    private static class WorldReferenceLostException
    extends WorldEditException {
        private WorldReferenceLostException(String message) {
            super(message);
        }
    }
}

