/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;

public class GuiDropDown
extends Gui {
    public static final Color background = new Color(0, 0, 0, 200);
    public static final Color trim = new Color(160, 160, 160, 255);
    public static final Color trimInside = new Color(50, 50, 50, 255);
    private static final int h = 11;
    private int x;
    private int y;
    private int xOffset = 0;
    private int yOffset = 0;
    private int w;
    private String[] realOptions = new String[0];
    private String[] options = new String[0];
    private int[] realValues = new int[0];
    private int[] values = new int[0];
    private int selected = 0;
    private boolean closed = true;
    protected String screenTitle;

    public GuiDropDown(String[] options, int x, int y, int w, Integer selected) {
        this(options, GuiDropDown.createDefaultValues(options.length), x, y, w, selected);
    }

    public GuiDropDown(String[] options, int[] values, int x, int y, int w, Integer selected) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.realOptions = options;
        this.realValues = values;
        this.selectValue(selected);
    }

    private static int[] createDefaultValues(int length) {
        int[] values = new int[length];
        for (int i = 0; i < length; ++i) {
            values[i] = i;
        }
        return values;
    }

    public int size() {
        return this.options.length;
    }

    public int getXWithOffset() {
        return this.x + this.xOffset;
    }

    public int getYWithOffset() {
        return this.y + this.yOffset;
    }

    public int getValue(int slot) {
        return this.values[slot];
    }

    public String getSelectedOption() {
        return this.realOptions[this.selected];
    }

    private void drawSlot(int id, int pos, int mouseX, int mouseY) {
        if (this.closed && this.onDropDown(mouseX, mouseY) || !this.closed && this.onDropDown(mouseX, mouseY, id)) {
            GuiDropDown.func_73734_a((int)this.getXWithOffset(), (int)(this.getYWithOffset() + 11 * pos), (int)(this.getXWithOffset() + this.w), (int)(this.getYWithOffset() + 11 + 11 * pos), (int)trimInside.hashCode());
        } else {
            GuiDropDown.func_73734_a((int)this.getXWithOffset(), (int)(this.getYWithOffset() + 11 * pos), (int)(this.getXWithOffset() + this.w), (int)(this.getYWithOffset() + 11 + 11 * pos), (int)background.hashCode());
        }
        this.func_73730_a(this.getXWithOffset() + 1, this.getXWithOffset() + this.w - 1, this.getYWithOffset() + 11 * pos, trimInside.hashCode());
        this.func_73732_a(Minecraft.func_71410_x().field_71466_p, I18n.func_135052_a((String)this.options[id], (Object[])new Object[0]).replace("\u00a7\u00a7", ":"), this.getXWithOffset() + this.w / 2, this.getYWithOffset() + 2 + 11 * pos, 0xFFFFFF);
    }

    private void drawSelection(int first, int amount, int mouseX, int mouseY) {
        int totalH = 11 * amount;
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int height = scaledresolution.func_78328_b();
        this.yOffset = this.y + totalH + 1 > height ? height - this.y - totalH - 1 : 0;
        for (int i = first; i < first + amount; ++i) {
            this.drawSlot(i, i - first, mouseX, mouseY);
        }
        this.func_73728_b(this.getXWithOffset(), this.getYWithOffset(), this.getYWithOffset() + totalH, trim.hashCode());
        this.func_73728_b(this.getXWithOffset() + this.w, this.getYWithOffset(), this.getYWithOffset() + totalH, trim.hashCode());
        this.func_73730_a(this.getXWithOffset(), this.getXWithOffset() + this.w, this.getYWithOffset(), trim.hashCode());
        this.func_73730_a(this.getXWithOffset(), this.getXWithOffset() + this.w, this.getYWithOffset() + totalH, trim.hashCode());
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (!this.closed) {
            int clickedValue = this.getClickedValue(mouseX, mouseY);
            if (clickedValue != -1) {
                this.selectValue(clickedValue);
            }
        } else if (this.options.length > 1) {
            this.closed = false;
        }
    }

    private int getClickedValue(int mouseX, int mouseY) {
        int xOnMenu = mouseX - this.getXWithOffset();
        int yOnMenu = mouseY - this.getYWithOffset();
        if (xOnMenu < 0 || yOnMenu < 0 || xOnMenu > this.w || yOnMenu >= this.options.length * 11) {
            return -1;
        }
        int slot = yOnMenu / 11;
        if (slot >= this.options.length) {
            slot = this.options.length - 1;
        }
        return this.values[slot];
    }

    public boolean onDropDown(int mouseX, int mouseY) {
        int xOnMenu = mouseX - this.getXWithOffset();
        int yOnMenu = mouseY - this.getYWithOffset();
        return xOnMenu >= 0 && yOnMenu >= 0 && xOnMenu <= this.w && yOnMenu < (this.closed ? 11 : this.options.length * 11);
    }

    public boolean onDropDown(int mouseX, int mouseY, int id) {
        int xOnMenu = mouseX - this.getXWithOffset();
        int yOnMenu = mouseY - this.getYWithOffset();
        return xOnMenu >= 0 && yOnMenu >= id * 11 && xOnMenu <= this.w && yOnMenu < id * 11 + 11;
    }

    public void selectValue(int id) {
        this.selected = id;
        this.closed = true;
        this.options = (String[])this.realOptions.clone();
        this.values = (int[])this.realValues.clone();
        this.options[0] = this.realOptions[this.selected];
        this.values[0] = this.realValues[this.selected];
        for (int i = this.selected; i > 0; --i) {
            this.options[i] = this.realOptions[i - 1];
            this.values[i] = this.realValues[i - 1];
        }
    }

    public void drawButton(int mouseX, int mouseY) {
        this.drawSelection(0, this.closed ? 1 : this.options.length, mouseX, mouseY);
    }

    public int getSelected() {
        return this.selected;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }
}

