/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.client.gui;

import info.ata4.minecraft.dragon.DragonMounts;
import info.ata4.minecraft.dragon.client.gui.GuiTextPrinter;
import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.breeds.EnumDragonBreed;
import info.ata4.minecraft.dragon.server.entity.helper.DragonBreedHelper;
import info.ata4.minecraft.dragon.server.entity.helper.DragonLifeStageHelper;
import info.ata4.minecraft.dragon.server.entity.helper.DragonReproductionHelper;
import info.ata4.minecraft.dragon.util.reflection.PrivateAccessor;
import java.text.DecimalFormat;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.lwjgl.input.Keyboard;

public class GuiDragonDebug
extends Gui
implements PrivateAccessor {
    private static final int WHITE = 0xFFFFFF;
    private static final int GREY = 0xAAAAAA;
    private static final int YELLOW = 0xFFFF00;
    private static final int RED = 0xFF8888;
    public static Object probe;
    public static boolean enabled;
    private final Minecraft mc = Minecraft.func_71410_x();
    private final FontRenderer fr;
    private final GuiTextPrinter text;
    private final DecimalFormat dfShort = new DecimalFormat("0.00");
    private final DecimalFormat dfLong = new DecimalFormat("0.0000");
    private ScaledResolution res;
    private EntityTameableDragon dragonClient;
    private EntityTameableDragon dragonServer;

    public GuiDragonDebug() {
        this.fr = this.mc.field_71466_p;
        this.text = new GuiTextPrinter(this.fr);
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent event) {
        if (!enabled || event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        this.getClientDragon();
        this.getServerDragon();
        if (this.dragonClient != null) {
            GuiIngameForge ingameGUI = (GuiIngameForge)this.mc.field_71456_v;
            this.res = ingameGUI.getResolution();
            this.renderTitle();
            try {
                if (Keyboard.isKeyDown((int)29)) {
                    this.renderNavigation();
                    this.renderAttributes();
                    this.renderBreedPoints();
                } else {
                    this.renderEntityInfo();
                    this.renderAITasks();
                }
                this.renderProbe();
            }
            catch (Exception ex) {
                this.renderException(ex);
            }
            if (this.dragonClient.field_70128_L) {
                this.dragonClient = null;
                this.dragonServer = null;
            }
        }
    }

    private void getClientDragon() {
        if (this.mc.field_71439_g.func_184187_bx() instanceof EntityTameableDragon) {
            this.dragonClient = (EntityTameableDragon)this.mc.field_71439_g.func_184187_bx();
            return;
        }
        if (this.mc.field_71476_x == null) {
            return;
        }
        if (this.mc.field_71476_x.field_72308_g == null) {
            return;
        }
        if (!(this.mc.field_71476_x.field_72308_g instanceof EntityTameableDragon)) {
            return;
        }
        this.dragonClient = (EntityTameableDragon)this.mc.field_71476_x.field_72308_g;
    }

    private void getServerDragon() {
        if (!this.mc.func_71356_B()) {
            return;
        }
        if (this.dragonClient == null) {
            this.dragonServer = null;
            return;
        }
        if (this.dragonServer != null && this.dragonServer.func_145782_y() == this.dragonClient.func_145782_y()) {
            return;
        }
        IntegratedServer mcs = this.mc.func_71401_C();
        for (WorldServer ws : mcs.field_71305_c) {
            Entity ent = ws.func_73045_a(this.dragonClient.func_145782_y());
            if (ent == null || !(ent instanceof EntityTameableDragon)) continue;
            this.dragonServer = (EntityTameableDragon)ent;
            return;
        }
    }

    private EntityTameableDragon getSelectedDragon() {
        return Keyboard.isKeyDown((int)42) ? this.dragonClient : this.dragonServer;
    }

    private void renderTitle() {
        String title = String.format("%s %s Debug", "Dragon Mounts", DragonMounts.instance.getMetadata().version);
        this.text.setOrigin(16, 8);
        this.text.setColor(0xAAAAAA);
        this.text.println(title);
        this.text.setColor(0xFFFFFF);
    }

    private void renderEntityInfo() {
        EntityLivingBase player;
        EntityTameableDragon dragon = this.getSelectedDragon();
        if (dragon == null) {
            return;
        }
        this.text.setOrigin(16, 32);
        this.text.setColor(0xFFFF00);
        this.text.println("Entity");
        this.text.setColor(0xFFFFFF);
        this.text.println("Side: " + (dragon.isServer() ? "server" : "client"));
        this.text.println("ID: " + dragon.func_145782_y());
        this.text.println("UUID: " + StringUtils.abbreviate((String)dragon.func_110124_au().toString(), (int)22));
        this.text.println("Name: " + dragon.func_70005_c_());
        String px = this.dfShort.format(dragon.field_70165_t);
        String py = this.dfShort.format(dragon.field_70163_u);
        String pz = this.dfShort.format(dragon.field_70161_v);
        this.text.printf("x: %s y: %s z: %s\n", px, py, pz);
        String pitch = this.dfShort.format(dragon.field_70125_A);
        String yaw = this.dfShort.format(dragon.field_70177_z);
        String yawHead = this.dfShort.format(dragon.field_70759_as);
        this.text.printf("p: %s y: %s yh: %s\n", pitch, yaw, yawHead);
        String health = this.dfShort.format(dragon.func_110143_aJ());
        String healthMax = this.dfShort.format(dragon.func_110138_aP());
        String healthRel = this.dfShort.format(dragon.getHealthRelative() * 100.0);
        this.text.printf("Health: %s/%s (%s%%)\n", health, healthMax, healthRel);
        this.text.print("Breed: ");
        EnumDragonBreed breedType = dragon.getBreedType();
        this.text.setColor(breedType.getBreed().getColor());
        this.text.println(breedType.func_176610_l());
        this.text.setColor(0xFFFFFF);
        DragonLifeStageHelper lifeStage = dragon.getLifeStageHelper();
        String lifeStageName = lifeStage.getLifeStage().name().toLowerCase();
        int ticksSinceCreation = dragon.getLifeStageHelper().getTicksSinceCreation();
        this.text.printf("Life stage: %s (%d)\n", lifeStageName, ticksSinceCreation);
        String scale = this.dfShort.format(lifeStage.getScale());
        String width = this.dfShort.format(dragon.field_70130_N);
        String height = this.dfShort.format(dragon.field_70131_O);
        this.text.printf("Size: %s (w:%s h:%s)\n", scale, width, height);
        String tamedString = dragon.func_70909_n() ? ((player = dragon.func_70902_q()) != null ? "yes (" + player.func_70005_c_() + ")" : "yes (" + StringUtils.abbreviate((String)dragon.func_184753_b().toString(), (int)22) + ")") : "no";
        this.text.println("Tamed: " + tamedString);
        DragonReproductionHelper reproduction = dragon.getReproductionHelper();
        EntityPlayer breeder = reproduction.getBreeder();
        String breederName = breeder == null ? "none" : breeder.func_70005_c_();
        this.text.println("Breeder: " + breederName);
        this.text.println("Reproduced: " + reproduction.getReproCount());
        this.text.println("Saddled: " + dragon.isSaddled());
    }

    private void renderAttributes() {
        EntityTameableDragon dragon = this.getSelectedDragon();
        if (dragon == null) {
            return;
        }
        this.text.setOrigin(this.text.getX() + 180, 8);
        this.text.setColor(0xFFFF00);
        this.text.println("Attributes");
        this.text.setColor(0xFFFFFF);
        Collection attribs = dragon.func_110140_aT().func_111146_a();
        attribs.forEach(attrib -> {
            String attribName = I18n.func_74838_a((String)("attribute.name." + attrib.func_111123_a().func_111108_a()));
            String attribValue = this.dfShort.format(attrib.func_111126_e());
            String attribBase = this.dfShort.format(attrib.func_111125_b());
            this.text.println(attribName + " = " + attribValue + " (" + attribBase + ")");
        });
        this.text.println();
    }

    private void renderBreedPoints() {
        if (this.dragonServer == null) {
            return;
        }
        this.text.setColor(0xFFFF00);
        this.text.println("Breed points");
        this.text.setColor(0xFFFFFF);
        DragonBreedHelper breedHelper = this.dragonServer.getBreedHelper();
        breedHelper.getBreedPoints().forEach((breedType, points) -> {
            this.text.setColor(breedType.getBreed().getColor());
            this.text.printf("%s: %d\n", breedType, points.get());
        });
    }

    private void renderNavigation() {
        this.text.setOrigin(16, 32);
        this.text.setColor(0xFFFF00);
        this.text.println("Navigation (Ground)");
        this.text.setColor(0xFFFFFF);
        PathNavigate nav = this.dragonServer.func_70661_as();
        PathNavigateGround pathNavigateGround = null;
        if (nav instanceof PathNavigateGround) {
            pathNavigateGround = (PathNavigateGround)nav;
        }
        this.text.println("Search range: " + nav.func_111269_d());
        this.text.println("Can swim: " + (pathNavigateGround == null ? "N/A" : Boolean.valueOf(pathNavigateGround.func_179684_h())));
        this.text.println("Break doors: " + (pathNavigateGround == null ? "N/A" : Boolean.valueOf(pathNavigateGround.func_179686_g())));
        this.text.println("No path: " + nav.func_75500_f());
        Path path = nav.func_75505_d();
        if (path != null) {
            this.text.println("Length: " + path.func_75874_d());
            this.text.println("Index: " + path.func_75873_e());
            PathPoint finalPoint = path.func_75870_c();
            this.text.println("Final point: " + finalPoint);
        }
        this.text.println();
        this.text.setColor(0xFFFF00);
        this.text.println("Navigation (Air)");
        this.text.setColor(0xFFFFFF);
        this.text.println("Can fly: " + this.dragonClient.canFly());
        this.text.println("Flying: " + this.dragonClient.isFlying());
        this.text.println("Altitude: " + this.dfLong.format(this.dragonClient.getAltitude()));
    }

    private void renderAITasks() {
        if (this.dragonServer == null) {
            return;
        }
        this.text.setOrigin(this.text.getX() + 180, 8);
        this.text.setColor(0xFFFF00);
        this.text.println("AI tasks");
        this.text.setColor(0xFFFFFF);
    }

    private void renderProbe() {
        if (probe == null) {
            return;
        }
        this.text.setOrigin(16, this.res.func_78328_b() - this.text.getLineSpace() * 2);
        this.text.println(probe.getClass().getSimpleName() + ":" + String.valueOf(probe));
    }

    private void renderException(Exception ex) {
        this.text.setOrigin(16, 32);
        this.text.setColor(0xFF8888);
        this.text.println("GUI exception:");
        this.text.printf(ExceptionUtils.getStackTrace((Throwable)ex), new Object[0]);
        this.text.setColor(0xFFFFFF);
    }

    static {
        enabled = true;
    }
}

