/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.client.handler;

import info.ata4.minecraft.dragon.DragonMounts;
import info.ata4.minecraft.dragon.util.reflection.PrivateAccessor;
import java.io.InputStream;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DragonSplash
implements PrivateAccessor {
    private static final Logger L = LogManager.getLogger();
    private static final ResourceLocation RESOURCE_SPLASHES = new ResourceLocation(DragonMounts.AID, "splashes.txt");
    private final Random rand = new Random();
    private List<String> splashLines;

    public DragonSplash() {
        try {
            InputStream is = null;
            try {
                is = Minecraft.func_71410_x().func_110442_L().func_110536_a(RESOURCE_SPLASHES).func_110527_b();
                this.splashLines = IOUtils.readLines((InputStream)is, (String)"UTF-8");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        catch (Throwable t) {
            L.warn("Can't load splashes", t);
        }
    }

    @SubscribeEvent
    public void onOpenGui(GuiOpenEvent evt) {
        GuiScreen gui = evt.getGui();
        if (gui instanceof GuiMainMenu) {
            try {
                GuiMainMenu menu = (GuiMainMenu)gui;
                String splash = this.mainMenuGetSplashText(menu);
                if (splash.equals("Kind of dragon free!")) {
                    splash = "Not really dragon free!";
                    this.mainMenuSetSplashText(menu, splash);
                } else if (this.splashLines != null && !this.splashLines.isEmpty() && this.rand.nextInt(10) == 0) {
                    splash = this.splashLines.get(this.rand.nextInt(this.splashLines.size()));
                    this.mainMenuSetSplashText(menu, splash);
                }
            }
            catch (Throwable t) {
                L.warn("Can't override splash", t);
            }
        }
    }
}

