/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.helper;

import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.ai.EntityAIDragonCatchOwner;
import info.ata4.minecraft.dragon.server.entity.ai.EntityAIDragonRide;
import info.ata4.minecraft.dragon.server.entity.ai.air.EntityAIDragonFollowOwner;
import info.ata4.minecraft.dragon.server.entity.ai.air.EntityAIDragonLand;
import info.ata4.minecraft.dragon.server.entity.ai.ground.EntityAIDragonHunt;
import info.ata4.minecraft.dragon.server.entity.ai.ground.EntityAIDragonMate;
import info.ata4.minecraft.dragon.server.entity.ai.ground.EntityAIDragonWatchIdle;
import info.ata4.minecraft.dragon.server.entity.ai.ground.EntityAIDragonWatchLiving;
import info.ata4.minecraft.dragon.server.entity.helper.DragonHelper;
import info.ata4.minecraft.dragon.server.util.EntityClassPredicate;
import java.util.ArrayList;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;

public class DragonBrain
extends DragonHelper {
    private final EntityAITasks tasks;
    private final EntityAITasks targetTasks;

    public DragonBrain(EntityTameableDragon dragon) {
        super(dragon);
        this.tasks = dragon.field_70714_bg;
        this.targetTasks = dragon.field_70715_bh;
    }

    public void setAvoidsWater(boolean avoidWater) {
        PathNavigate pathNavigate = this.dragon.func_70661_as();
        if (pathNavigate instanceof PathNavigateGround) {
            PathNavigateGround pathNavigateGround = (PathNavigateGround)pathNavigate;
            pathNavigateGround.func_179693_d(!avoidWater);
        }
    }

    public void clearTasks() {
        this.clearTasks(this.tasks);
        this.clearTasks(this.targetTasks);
    }

    public void clearTasks(EntityAITasks tasks) {
        ArrayList taskEntries = new ArrayList(tasks.field_75782_a);
        taskEntries.forEach(entry -> tasks.func_85156_a(entry.field_75733_a));
    }

    public void updateAITasks() {
        if (this.dragon.func_70661_as() instanceof PathNavigateGround) {
            PathNavigateGround pathNavigateGround = (PathNavigateGround)this.dragon.func_70661_as();
            pathNavigateGround.func_179691_c(this.dragon.isHatchling());
        }
        this.dragon.func_70661_as().func_75499_g();
        this.clearTasks();
        if (this.dragon.isEgg()) {
            return;
        }
        this.tasks.func_75776_a(0, (EntityAIBase)new EntityAIDragonCatchOwner(this.dragon));
        this.tasks.func_75776_a(1, (EntityAIBase)new EntityAIDragonRide(this.dragon));
        this.tasks.func_75776_a(2, (EntityAIBase)new EntityAIDragonFollowOwner(this.dragon));
        this.tasks.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this.dragon, 1.0));
        if (this.dragon.isFlying()) {
            this.tasks.func_75776_a(3, (EntityAIBase)new EntityAIDragonLand(this.dragon, 1.0));
        } else {
            this.tasks.func_75776_a(2, (EntityAIBase)new EntityAISwimming((EntityLiving)this.dragon));
            this.tasks.func_75776_a(4, (EntityAIBase)this.dragon.func_70907_r());
            this.tasks.func_75776_a(6, (EntityAIBase)new EntityAITempt((EntityCreature)this.dragon, 0.75, this.dragon.getBreed().getBreedingItem(), false));
            this.tasks.func_75776_a(7, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this.dragon, 1.0, true));
            this.tasks.func_75776_a(10, (EntityAIBase)new EntityAIWander((EntityCreature)this.dragon, 1.0));
            this.tasks.func_75776_a(11, (EntityAIBase)new EntityAIDragonWatchIdle(this.dragon));
            this.tasks.func_75776_a(11, (EntityAIBase)new EntityAIDragonWatchLiving(this.dragon, 16.0f, 0.05f));
            this.targetTasks.func_75776_a(5, (EntityAIBase)new EntityAIDragonHunt(this.dragon, EntityAnimal.class, false, new EntityClassPredicate(EntitySheep.class, EntityPig.class, EntityChicken.class, EntityRabbit.class)));
            if (this.dragon.isHatchling()) {
                this.tasks.func_75776_a(8, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this.dragon, 0.8));
                this.tasks.func_75776_a(9, (EntityAIBase)new EntityAIPanic((EntityCreature)this.dragon, 1.0));
            } else {
                this.targetTasks.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this.dragon));
                this.targetTasks.func_75776_a(3, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this.dragon));
                this.targetTasks.func_75776_a(4, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this.dragon, false, new Class[0]));
            }
            if (this.dragon.isAdult()) {
                this.tasks.func_75776_a(5, (EntityAIBase)new EntityAIDragonMate(this.dragon, 0.6));
            }
        }
    }
}

