/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.helper;

import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.helper.DragonHelper;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;

public class DragonSoundManager
extends DragonHelper {
    public DragonSoundManager(EntityTameableDragon dragon) {
        super(dragon);
    }

    public SoundEvent getLivingSound() {
        if (this.dragon.isEgg() || this.dragon.isFlying()) {
            return null;
        }
        return this.dragon.getBreed().getLivingSound();
    }

    public SoundEvent getHurtSound() {
        if (this.dragon.isEgg()) {
            return SoundEvents.field_187927_ha;
        }
        return this.dragon.getBreed().getHurtSound();
    }

    public SoundEvent getDeathSound() {
        if (this.dragon.isEgg()) {
            return SoundEvents.field_187929_hc;
        }
        return this.dragon.getBreed().getDeathSound();
    }

    public SoundEvent getWingsSound() {
        return this.dragon.getBreed().getWingsSound();
    }

    public SoundEvent getStepSound() {
        return this.dragon.getBreed().getStepSound();
    }

    public SoundEvent getEatSound() {
        return this.dragon.getBreed().getEatSound();
    }

    public SoundEvent getAttackSound() {
        return this.dragon.getBreed().getAttackSound();
    }

    public void playLivingSound() {
        SoundEvent sound = this.getLivingSound();
        if (sound == null) {
            return;
        }
        this.playSound(sound, 1.0f, 1.0f);
    }

    public int getTalkInterval() {
        return 240;
    }

    public void onWingsDown(float speed) {
        if (!this.dragon.func_70090_H()) {
            float pitch = 1.0f - speed;
            float volume = 0.3f + (1.0f - speed) * 0.2f;
            this.playSound(this.getWingsSound(), volume, pitch, true);
        }
    }

    public void playStepSound(BlockPos entityPos, Block block) {
        if (this.dragon.isEgg() || this.dragon.func_70090_H()) {
            return;
        }
        SoundType soundType = this.dragon.field_70170_p.func_180495_p(entityPos.func_177984_a()).func_177230_c() == Blocks.field_150431_aC ? Blocks.field_150431_aC.func_185467_w() : block.func_185467_w();
        SoundEvent stepSound = this.dragon.isHatchling() ? soundType.func_185844_d() : this.getStepSound();
        this.playSound(stepSound, soundType.func_185843_a(), soundType.func_185847_b());
    }

    public void playSound(SoundEvent sound, float volume, float pitch, boolean local) {
        if (sound == null || this.dragon.func_174814_R()) {
            return;
        }
        volume *= this.getVolume(sound);
        pitch *= this.getPitch(sound);
        if (local) {
            this.dragon.field_70170_p.func_184134_a(this.dragon.field_70165_t, this.dragon.field_70163_u, this.dragon.field_70161_v, sound, this.dragon.func_184176_by(), volume, pitch, false);
        } else {
            this.dragon.field_70170_p.func_184148_a(null, this.dragon.field_70165_t, this.dragon.field_70163_u, this.dragon.field_70161_v, sound, this.dragon.func_184176_by(), volume, pitch);
        }
    }

    public void playSound(SoundEvent sound, float volume, float pitch) {
        this.playSound(sound, volume, pitch, false);
    }

    public float getVolume(SoundEvent sound) {
        return this.dragon.getScale() * this.dragon.getBreed().getSoundVolume(sound);
    }

    public float getPitch(SoundEvent sound) {
        return (2.0f - this.dragon.getScale()) * this.dragon.getBreed().getSoundPitch(sound);
    }
}

