/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.util;

public class ClientServerSynchronisedTickCount {
    private int cachedRemoteTickCount;
    private int ticksToInsert;
    private double localTickCount;
    private double localTickRate;
    private final double MAXIMUM_MISMATCH = 100.0;
    private final double expectedUpdateInterval;

    public ClientServerSynchronisedTickCount(int i_expectedUpdateIntervalTicks) {
        this.expectedUpdateInterval = i_expectedUpdateIntervalTicks;
        this.reset(0);
    }

    public void reset(int newValue) {
        this.ticksToInsert = 0;
        this.localTickRate = 1.0;
        this.cachedRemoteTickCount = newValue;
        this.localTickCount = newValue;
    }

    public int tick() {
        int beforeTick = this.getCurrentTickCount();
        this.localTickCount += this.localTickRate;
        int afterTick = this.getCurrentTickCount();
        int extraTicksInserted = afterTick - beforeTick - 1;
        this.ticksToInsert -= extraTicksInserted;
        return afterTick;
    }

    public void updateFromServer(int remoteTickCount) {
        if (remoteTickCount == this.cachedRemoteTickCount) {
            return;
        }
        double mismatch = (double)remoteTickCount - this.localTickCount;
        if (mismatch < -100.0 || mismatch > 100.0) {
            this.ticksToInsert = 0;
            this.localTickCount = remoteTickCount;
        } else {
            this.ticksToInsert = (int)mismatch;
        }
        this.localTickRate = 1.0 + (double)this.ticksToInsert / this.expectedUpdateInterval;
        this.cachedRemoteTickCount = remoteTickCount;
    }

    public int getCurrentTickCount() {
        if (this.localTickRate < -2.147483648E9 || this.localTickRate > 2.147483647E9) {
            return 0;
        }
        return (int)this.localTickCount;
    }
}

