/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.renderer;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.ClientProxy;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderZombie;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class LayerStone
implements LayerRenderer<EntityLivingBase> {
    protected ModelBase model;
    private final RenderLivingBase<?> renderer;
    private static final ResourceLocation texture = new ResourceLocation("textures/blocks/stone.png");
    private static final Field zombieLayers = ReflectionHelper.findField(RenderZombie.class, (String[])new String[]{"defaultLayers", "field_177122_o"});
    private static final Field zombieVillagerLayers = ReflectionHelper.findField(RenderZombie.class, (String[])new String[]{"villagerLayers", "field_177121_n"});
    private static final Method swapZombieModel = ReflectionHelper.findMethod(RenderZombie.class, null, (String[])new String[]{"swapArmor", "func_82427_a"}, (Class[])new Class[]{EntityZombie.class});

    public static void initialiseLayers() {
        for (Map.Entry entry : Minecraft.func_71410_x().func_175598_ae().field_78729_o.entrySet()) {
            if (entry.getValue() instanceof RenderZombie) {
                try {
                    Object layers = zombieLayers.get(entry.getValue());
                    if (layers instanceof List) {
                        ((List)layers).add(new LayerStone((RenderLivingBase)entry.getValue()));
                    }
                    if (!((layers = zombieVillagerLayers.get(entry.getValue())) instanceof List)) continue;
                    ((List)layers).add(new LayerStone((RenderLivingBase)entry.getValue()));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    Wizardry.logger.error("Error while reflectively accessing zombie render layers");
                    e.printStackTrace();
                }
                continue;
            }
            if (!(entry.getValue() instanceof RenderLivingBase)) continue;
            ((RenderLivingBase)entry.getValue()).func_177094_a((LayerRenderer)new LayerStone((RenderLivingBase)entry.getValue()));
        }
    }

    public LayerStone(RenderLivingBase<?> renderer) {
        this.renderer = renderer;
        this.model = renderer.func_177087_b();
    }

    public void func_177141_a(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (entity.getEntityData().func_74767_n("petrified")) {
            GlStateManager.func_179145_e();
            int i = this.getBlockBrightnessForEntity((Entity)entity, partialTicks);
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
            ResourceLocation breakingTexture = ClientProxy.renderStatue.getBlockBreakingTexture();
            if (breakingTexture != null) {
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.renderer.func_110776_a(breakingTexture);
                this.renderEntityModel(entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
                GlStateManager.func_179084_k();
            } else {
                this.renderer.func_110776_a(texture);
                this.renderEntityModel(entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
            }
        }
    }

    private int getBlockBrightnessForEntity(Entity entity, float partialTicks) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), 0, MathHelper.func_76128_c((double)entity.field_70161_v));
        if (entity.field_70170_p.func_175667_e((BlockPos)pos)) {
            pos.func_185336_p(MathHelper.func_76128_c((double)(entity.field_70163_u + (double)entity.func_70047_e())));
            return entity.field_70170_p.func_175626_b((BlockPos)pos, 0);
        }
        return 0;
    }

    private void renderEntityModel(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        double scaleX = 1.0;
        double scaleY = 1.0;
        if (this.model.field_78092_r != null && this.model.field_78092_r.get(0) != null) {
            scaleX = (double)((ModelRenderer)this.model.field_78092_r.get((int)0)).field_78801_a / 16.0;
            scaleY = (double)((ModelRenderer)this.model.field_78092_r.get((int)0)).field_78799_b / 16.0;
        } else {
            scaleX = (double)this.model.field_78090_t / 16.0;
            scaleY = (double)this.model.field_78089_u / 16.0;
        }
        GlStateManager.func_179139_a((double)scaleX, (double)scaleY, (double)1.0);
        GlStateManager.func_179128_n((int)5888);
        if (this.renderer instanceof RenderZombie && entity instanceof EntityZombie) {
            try {
                swapZombieModel.invoke(this.renderer, entity);
                this.model = this.renderer.func_177087_b();
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Wizardry.logger.error("Error while reflectively calling RenderZombie#swapArmor");
                e.printStackTrace();
            }
        }
        if (this.model instanceof ModelBiped) {
            ((ModelBiped)this.model).field_178720_f.field_78807_k = true;
        }
        this.model.func_78086_a(entity, limbSwing, limbSwingAmount, partialTicks);
        this.model.func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        if (this.model instanceof ModelBiped) {
            ((ModelBiped)this.model).field_178720_f.field_78807_k = false;
        }
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
    }

    public boolean func_177142_b() {
        return false;
    }
}

