/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.living;

import com.google.common.base.Predicate;
import electroblob.wizardry.WizardData;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.IndirectMinionDamage;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.MinionDamage;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

@Mod.EventBusSubscriber
public interface ISummonedCreature
extends IEntityAdditionalSpawnData {
    public static final String NAMEPLATE_TRANSLATION_KEY = "entity.wizardry.summonedcreature.nameplate";

    public void setLifetime(int var1);

    public int getLifetime();

    public void setCasterReference(WeakReference<EntityLivingBase> var1);

    @Nullable
    public WeakReference<EntityLivingBase> getCasterReference();

    public void setCasterUUID(UUID var1);

    public UUID getCasterUUID();

    @Nullable
    default public EntityLivingBase getCaster() {
        return this.getCasterReference() == null ? null : (EntityLivingBase)this.getCasterReference().get();
    }

    default public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.getCaster() != null ? this.getCaster().func_145782_y() : -1);
        buffer.writeInt(this.getLifetime());
    }

    default public void readSpawnData(ByteBuf buffer) {
        int id = buffer.readInt();
        if (id > -1) {
            this.setCasterReference(new WeakReference<EntityLivingBase>((EntityLivingBase)Wizardry.proxy.getTheWorld().func_73045_a(id)));
        }
        this.setLifetime(buffer.readInt());
    }

    default public boolean isValidTarget(Entity target) {
        return WizardryUtilities.isValidTarget((Entity)this.getCaster(), target);
    }

    default public Predicate<Entity> getTargetSelector() {
        return new Predicate<Entity>(){

            public boolean apply(Entity entity) {
                if (!entity.func_82150_aj() && ISummonedCreature.this.isValidTarget(entity)) {
                    if (entity instanceof EntityPlayer) {
                        return true;
                    }
                    if ((entity instanceof IMob || entity instanceof ISummonedCreature || entity instanceof EntityWizard && !(ISummonedCreature.this.getCaster() instanceof EntityWizard) || Arrays.asList(Wizardry.settings.summonedCreatureTargetsWhitelist).contains(EntityList.func_75621_b((Entity)entity).toLowerCase(Locale.ROOT))) && !Arrays.asList(Wizardry.settings.summonedCreatureTargetsBlacklist).contains(EntityList.func_75621_b((Entity)entity).toLowerCase(Locale.ROOT))) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public void onSpawn();

    public void onDespawn();

    public boolean hasParticleEffect();

    default public void onSuccessfulAttack(EntityLivingBase target) {
    }

    default public void writeNBTDelegate(NBTTagCompound tagcompound) {
        if (this.getCaster() != null) {
            tagcompound.func_186854_a("casterUUID", this.getCaster().func_110124_au());
        }
        tagcompound.func_74768_a("lifetime", this.getLifetime());
    }

    default public void readNBTDelegate(NBTTagCompound tagcompound) {
        this.setCasterUUID(tagcompound.func_186857_a("casterUUID"));
        this.setLifetime(tagcompound.func_74762_e("lifetime"));
    }

    default public boolean shouldRevengeTarget(EntityLivingBase entity) {
        return entity != this.getCaster() || Wizardry.settings.minionRevengeTargeting;
    }

    default public void updateDelegate() {
        Entity entity;
        if (!(this instanceof Entity)) {
            throw new ClassCastException("Implementations of ISummonedCreature must extend Entity!");
        }
        Entity thisEntity = (Entity)this;
        if (this.getCaster() == null && this.getCasterUUID() != null && (entity = WizardryUtilities.getEntityByUUID(thisEntity.field_70170_p, this.getCasterUUID())) instanceof EntityLivingBase) {
            this.setCasterReference(new WeakReference<EntityLivingBase>((EntityLivingBase)entity));
        }
        if (thisEntity.field_70173_aa == 1) {
            this.onSpawn();
        }
        if (thisEntity.field_70173_aa > this.getLifetime() && this.getLifetime() != -1) {
            this.onDespawn();
            thisEntity.func_70106_y();
        }
        if (this.hasParticleEffect() && thisEntity.field_70170_p.field_72995_K && thisEntity.field_70170_p.field_73012_v.nextInt(8) == 0) {
            Wizardry.proxy.spawnParticle(WizardryParticleType.DARK_MAGIC, thisEntity.field_70170_p, thisEntity.field_70165_t, thisEntity.field_70163_u + thisEntity.field_70170_p.field_73012_v.nextDouble() * 1.5, thisEntity.field_70161_v, 0.0, 0.0, 0.0, 0, 0.1f, 0.0f, 0.0f);
        }
    }

    default public boolean interactDelegate(EntityPlayer player, EnumHand hand, ItemStack stack) {
        WizardData properties = WizardData.get(player);
        if (player.func_70093_af() && stack != null && stack.func_77973_b() instanceof ItemWand) {
            if (!player.field_70170_p.field_72995_K && properties != null && this.getCaster() == player) {
                properties.selectedMinion = properties.selectedMinion != null && properties.selectedMinion.get() == this ? null : new WeakReference<ISummonedCreature>(this);
                properties.sync();
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        EntityLivingBase summoner;
        if (event.getSource().func_76346_g() instanceof ISummonedCreature && (summoner = ((ISummonedCreature)event.getSource().func_76346_g()).getCaster()) != null) {
            boolean isRetaliatory;
            event.setCanceled(true);
            Object newSource = event.getSource();
            MagicDamage.DamageType type = event.getSource() instanceof IElementalDamage ? ((IElementalDamage)event.getSource()).getType() : MagicDamage.DamageType.MAGIC;
            boolean bl = isRetaliatory = event.getSource() instanceof IElementalDamage && ((IElementalDamage)event.getSource()).isRetaliatory();
            if (event.getSource() instanceof EntityDamageSourceIndirect) {
                newSource = new IndirectMinionDamage(event.getSource().field_76373_n, event.getSource().func_76364_f(), event.getSource().func_76346_g(), (Entity)summoner, type, isRetaliatory);
            } else if (event.getSource() instanceof EntityDamageSource) {
                newSource = new MinionDamage(event.getSource().field_76373_n, event.getSource().func_76346_g(), (Entity)summoner, type, isRetaliatory);
            }
            if (event.getSource().func_94541_c()) {
                newSource.func_94540_d();
            }
            if (event.getSource().func_76347_k()) {
                newSource.func_76361_j();
            }
            if (event.getSource().func_76352_a()) {
                newSource.func_76349_b();
            }
            if (WizardryUtilities.attackEntityWithoutKnockback(event.getEntity(), newSource, event.getAmount())) {
                WizardryUtilities.applyStandardKnockback(event.getSource().func_76346_g(), event.getEntityLiving());
                ((ISummonedCreature)event.getSource().func_76346_g()).onSuccessfulAttack(event.getEntityLiving());
            }
        }
    }
}

