/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.WizardData;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.packet.PacketClairvoyance;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryPathFinder;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class Clairvoyance
extends Spell {
    public static final int PARTICLE_MOVEMENT_INTERVAL = 45;

    public Clairvoyance() {
        super(Tier.APPRENTICE, 20, Element.SORCERY, "clairvoyance", SpellType.UTILITY, 100, EnumAction.BOW, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        WizardData properties = WizardData.get(caster);
        if (properties != null && !caster.func_70093_af()) {
            if (caster.field_71093_bK == properties.getClairvoyanceDimension()) {
                if (properties.getClairvoyanceLocation() != null) {
                    if (!world.field_72995_K) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.clairvoyance.searching", new Object[0]));
                    }
                    EntityZombie arbitraryZombie = new EntityZombie(world){

                        public float func_180484_a(BlockPos pos) {
                            return 0.0f;
                        }
                    };
                    arbitraryZombie.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)(256.0f * modifiers.get(WizardryItems.range_upgrade)));
                    arbitraryZombie.func_70107_b(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v);
                    arbitraryZombie.func_184644_a(PathNodeType.WATER, 0.0f);
                    arbitraryZombie.field_70122_E = true;
                    BlockPos destination = properties.getClairvoyanceLocation();
                    WizardryPathFinder pathfinder = new WizardryPathFinder(arbitraryZombie.func_70661_as().func_189566_q());
                    Path path = pathfinder.findPath((IBlockAccess)world, (EntityLiving)arbitraryZombie, destination, 256.0f * modifiers.get(WizardryItems.range_upgrade));
                    if (path != null && path.func_75870_c() != null) {
                        int x = path.func_75870_c().field_75839_a;
                        int y = path.func_75870_c().field_75837_b;
                        int z = path.func_75870_c().field_75838_c;
                        if (x == destination.func_177958_n() && y == destination.func_177956_o() && z == destination.func_177952_p()) {
                            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_CONJURATION, 1.0f, 1.0f);
                            if (!world.field_72995_K && caster instanceof EntityPlayerMP) {
                                WizardryPacketHandler.net.sendTo((IMessage)new PacketClairvoyance.Message(path, modifiers.get(WizardryItems.duration_upgrade)), (EntityPlayerMP)caster);
                            }
                            return true;
                        }
                    }
                    if (!world.field_72995_K) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.clairvoyance.outofrange", new Object[0]));
                    }
                } else if (!world.field_72995_K) {
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.clairvoyance.undefined", new Object[0]));
                }
            } else if (!world.field_72995_K) {
                caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.clairvoyance.wrongdimension", new Object[0]));
            }
        }
        if (world.field_72995_K) {
            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_CONJURATION, 1.0f, 1.0f);
        }
        return false;
    }

    public static void spawnPathPaticles(World world, Path path, float durationMultiplier) {
        PathPoint point;
        while (!path.func_75879_b() && (point = path.func_75877_a(path.func_75873_e())) != path.func_75870_c()) {
            PathPoint nextPoint = path.func_75874_d() - path.func_75873_e() <= 2 ? path.func_75870_c() : path.func_75877_a(path.func_75873_e() + 2);
            Wizardry.proxy.spawnParticle(WizardryParticleType.PATH, world, (double)point.field_75839_a + 0.5, (double)point.field_75837_b + 0.5, (double)point.field_75838_c + 0.5, (float)(nextPoint.field_75839_a - point.field_75839_a) / 45.0f, (float)(nextPoint.field_75837_b - point.field_75837_b) / 45.0f, (float)(nextPoint.field_75838_c - point.field_75838_c) / 45.0f, (int)(1800.0f * durationMultiplier), 0.0f, 1.0f, 0.3f);
            path.func_75875_a();
            path.func_75875_a();
        }
        point = path.func_75870_c();
        Wizardry.proxy.spawnParticle(WizardryParticleType.PATH, world, (double)point.field_75839_a + 0.5, (double)point.field_75837_b + 0.5, (double)point.field_75838_c + 0.5, 0.0, 0.0, 0.0, (int)(1800.0f * durationMultiplier), 1.0f, 1.0f, 1.0f);
    }

    @SubscribeEvent
    public static void onRightClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        WizardData properties;
        ItemStack wand;
        if (event.getEntityPlayer().func_70093_af() && (wand = event.getItemStack()) != null && wand.func_77973_b() instanceof ItemWand && WandHelper.getCurrentSpell(wand) instanceof Clairvoyance && (properties = WizardData.get(event.getEntityPlayer())) != null) {
            BlockPos pos = event.getPos().func_177972_a(event.getFace());
            properties.setClairvoyancePoint(pos, event.getWorld().field_73011_w.getDimension());
            if (!event.getWorld().field_72995_K) {
                event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("spell.clairvoyance.confirm", new Object[]{Spells.clairvoyance.getNameForTranslationFormatted()}));
            }
            event.setCanceled(true);
        }
    }
}

