/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.construct.EntityDecay;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class Decay
extends Spell {
    public Decay() {
        super(Tier.ADVANCED, 50, Element.NECROMANCY, "decay", SpellType.ATTACK, 200, EnumAction.NONE, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        RayTraceResult rayTrace = WizardryUtilities.rayTrace(12.0f * modifiers.get(WizardryItems.range_upgrade), world, (EntityLivingBase)caster, false);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = rayTrace.func_178782_a();
            if (world.func_180495_p(pos.func_177984_a()).func_185915_l()) {
                return false;
            }
            if (!world.field_72995_K) {
                BlockPos pos1;
                world.func_72838_d((Entity)new EntityDecay(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5, (EntityLivingBase)caster));
                for (int i = 0; i < 5 && (pos1 = WizardryUtilities.findNearbyFloorSpace((Entity)caster, 2, 6)) != null; ++i) {
                    world.func_72838_d((Entity)new EntityDecay(world, (double)pos1.func_177958_n() + 0.5, pos1.func_177956_o(), (double)pos1.func_177952_p() + 0.5, (EntityLivingBase)caster));
                }
            }
            WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187853_gC, 1.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f);
            caster.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            int z;
            int y;
            int x = MathHelper.func_76128_c((double)target.field_70165_t);
            if (world.func_180495_p(new BlockPos(x, y = (int)target.func_174813_aQ().field_72338_b, z = MathHelper.func_76128_c((double)target.field_70161_v))).func_185915_l()) {
                return false;
            }
            if (!world.field_72995_K) {
                BlockPos pos;
                world.func_72838_d((Entity)new EntityDecay(world, (double)x + 0.5, y + 1, (double)z + 0.5, (EntityLivingBase)caster));
                for (int i = 0; i < 5 && (pos = WizardryUtilities.findNearbyFloorSpace((Entity)caster, 2, 6)) != null; ++i) {
                    world.func_72838_d((Entity)new EntityDecay(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, (EntityLivingBase)caster));
                }
            }
            caster.func_184185_a(SoundEvents.field_187853_gC, 1.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f);
            caster.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

