/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class Firestorm
extends Spell {
    public Firestorm() {
        super(Tier.MASTER, 15, Element.FIRE, "firestorm", SpellType.ATTACK, 0, EnumAction.NONE, true);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        BlockPos pos;
        Vec3d look = caster.func_70040_Z();
        RayTraceResult rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * modifiers.get(WizardryItems.range_upgrade));
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.ENTITY && rayTrace.field_72308_g instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)rayTrace.field_72308_g;
            if (!MagicDamage.isEntityImmune(MagicDamage.DamageType.FIRE, (Entity)target)) {
                target.func_70015_d(10);
                WizardryUtilities.attackEntityWithoutKnockback((Entity)target, MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.FIRE), 6.0f * modifiers.get("damage"));
            } else if (!world.field_72995_K && ticksInUse == 1) {
                caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}));
            }
        } else if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && world.func_175623_d(pos = rayTrace.func_178782_a().func_177972_a(rayTrace.field_178784_b)) && !world.field_72995_K) {
            world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
        }
        if (world.field_72995_K) {
            for (int i = 0; i < 40; ++i) {
                double x1 = caster.field_70165_t + look.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() * 0.6f) - (double)0.3f;
                double y1 = WizardryUtilities.getPlayerEyesPos(caster) - (double)0.4f + look.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() * 0.4f) - (double)0.2f;
                double z1 = caster.field_70161_v + look.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() * 0.6f) - (double)0.3f;
                Wizardry.proxy.spawnParticle(WizardryParticleType.MAGIC_FIRE, world, x1, y1, z1, look.field_72450_a * (double)modifiers.get(WizardryItems.range_upgrade), look.field_72448_b * (double)modifiers.get(WizardryItems.range_upgrade), look.field_72449_c * (double)modifiers.get(WizardryItems.range_upgrade), 0, 3.0f + world.field_73012_v.nextFloat(), 0.0f, 0.0f);
                Wizardry.proxy.spawnParticle(WizardryParticleType.MAGIC_FIRE, world, x1, y1, z1, look.field_72450_a * (double)modifiers.get(WizardryItems.range_upgrade), look.field_72448_b * (double)modifiers.get(WizardryItems.range_upgrade), look.field_72449_c * (double)modifiers.get(WizardryItems.range_upgrade), 0, 3.0f + world.field_73012_v.nextFloat(), 0.0f, 0.0f);
            }
        }
        if (ticksInUse % 16 == 0) {
            if (ticksInUse == 0) {
                WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187606_E, 1.0f, 1.0f);
            }
            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_LOOP_FIRE, 0.5f, 1.0f);
        }
        return true;
    }
}

