/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.WizardData;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryEnchantments;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ImbueWeapon
extends Spell {
    public ImbueWeapon() {
        super(Tier.APPRENTICE, 20, Element.SORCERY, "imbue_weapon", SpellType.UTILITY, 50, EnumAction.BOW, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (WizardData.get(caster) != null) {
            for (ItemStack stack : WizardryUtilities.getPrioritisedHotbarAndOffhand(caster)) {
                if (stack == null) continue;
                if (stack.func_77973_b() instanceof ItemSword && !EnchantmentHelper.func_82781_a((ItemStack)stack).containsKey(WizardryEnchantments.magic_sword) && WizardData.get(caster).getImbuementDuration(WizardryEnchantments.magic_sword) <= 0) {
                    stack.func_77966_a(WizardryEnchantments.magic_sword, modifiers.get("damage") == 1.0f ? 1 : (int)((modifiers.get("damage") - 1.0f) / 0.15f + 0.5f));
                    WizardData.get(caster).setImbuementDuration(WizardryEnchantments.magic_sword, (int)(900.0f * modifiers.get(WizardryItems.duration_upgrade)));
                } else {
                    if (!(stack.func_77973_b() instanceof ItemBow) || EnchantmentHelper.func_82781_a((ItemStack)stack).containsKey(WizardryEnchantments.magic_bow) || WizardData.get(caster).getImbuementDuration(WizardryEnchantments.magic_bow) > 0) continue;
                    stack.func_77966_a(WizardryEnchantments.magic_bow, modifiers.get("damage") == 1.0f ? 1 : (int)((modifiers.get("damage") - 1.0f) / 0.15f + 0.5f));
                    WizardData.get(caster).setImbuementDuration(WizardryEnchantments.magic_bow, (int)(900.0f * modifiers.get(WizardryItems.duration_upgrade)));
                }
                if (world.field_72995_K) {
                    for (int i = 0; i < 10; ++i) {
                        double x1 = (float)caster.field_70165_t + world.field_73012_v.nextFloat() * 2.0f - 1.0f;
                        double y1 = (float)WizardryUtilities.getPlayerEyesPos(caster) - 0.5f + world.field_73012_v.nextFloat();
                        double z1 = (float)caster.field_70161_v + world.field_73012_v.nextFloat() * 2.0f - 1.0f;
                        Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, x1, y1, z1, 0.0, 0.1f, 0.0, 48 + world.field_73012_v.nextInt(12), 0.9f, 0.7f, 1.0f);
                    }
                }
                WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_CONJURATION, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }
}

