/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.EntityArc;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class LightningRay
extends Spell {
    public LightningRay() {
        super(Tier.APPRENTICE, 5, Element.LIGHTNING, "lightning_ray", SpellType.ATTACK, 0, EnumAction.NONE, true);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        RayTraceResult rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * modifiers.get(WizardryItems.range_upgrade), 2.0f);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.ENTITY && rayTrace.field_72308_g instanceof EntityLivingBase) {
            Entity target = rayTrace.field_72308_g;
            if (!world.field_72995_K) {
                if (ticksInUse % 2 == 0) {
                    EntityArc arc = new EntityArc(world);
                    arc.setEndpointCoords(caster.field_70165_t, caster.field_70163_u + 1.2, caster.field_70161_v, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v);
                    arc.lifetime = 1;
                    world.func_72838_d((Entity)arc);
                }
                if (MagicDamage.isEntityImmune(MagicDamage.DamageType.SHOCK, target)) {
                    if (!world.field_72995_K && ticksInUse == 1) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}));
                    }
                } else {
                    WizardryUtilities.attackEntityWithoutKnockback(target, MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.SHOCK), 3.0f * modifiers.get("damage"));
                }
            } else {
                for (int i = 0; i < 5; ++i) {
                    Wizardry.proxy.spawnParticle(WizardryParticleType.SPARK, world, target.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, target.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, 3);
                }
            }
            if (ticksInUse == 1) {
                WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_LIGHTNING, 1.0f, 1.0f);
            } else if (ticksInUse > 0 && ticksInUse % 20 == 0) {
                WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_LOOP_LIGHTNING, 1.0f, 1.0f);
            }
            return true;
        }
        if (!world.field_72995_K && ticksInUse % 2 == 0) {
            EntityArc arc = new EntityArc(world);
            arc.setEndpointCoords(caster.field_70165_t, caster.field_70163_u + 1.2, caster.field_70161_v, caster.field_70165_t + caster.func_70040_Z().field_72450_a * 8.0, caster.field_70163_u + (double)caster.eyeHeight + caster.func_70040_Z().field_72448_b * 8.0, caster.field_70161_v + caster.func_70040_Z().field_72449_c * 8.0);
            arc.lifetime = 1;
            world.func_72838_d((Entity)arc);
        }
        if (ticksInUse == 1) {
            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_LIGHTNING, 1.0f, 1.0f);
        } else if (ticksInUse > 0 && ticksInUse % 20 == 0) {
            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_LOOP_LIGHTNING, 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            if (!world.field_72995_K) {
                if (ticksInUse % 2 == 0) {
                    EntityArc arc = new EntityArc(world);
                    arc.setEndpointCoords(caster.field_70165_t, caster.field_70163_u + 1.2, caster.field_70161_v, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v);
                    arc.lifetime = 1;
                    world.func_72838_d((Entity)arc);
                }
                WizardryUtilities.attackEntityWithoutKnockback((Entity)target, MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.SHOCK), 3.0f * modifiers.get("damage"));
            } else {
                for (int i = 0; i < 5; ++i) {
                    Wizardry.proxy.spawnParticle(WizardryParticleType.SPARK, world, target.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, target.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, 3);
                }
            }
            if (ticksInUse == 1) {
                caster.func_184185_a(WizardrySounds.SPELL_LIGHTNING, 1.0f, 1.0f);
            } else if (ticksInUse > 0 && ticksInUse % 20 == 0) {
                caster.func_184185_a(WizardrySounds.SPELL_LOOP_LIGHTNING, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

