/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.living.EntityEvilWizard;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class MindControl
extends Spell {
    public static final String NBT_KEY = "controllingEntity";

    public MindControl() {
        super(Tier.ADVANCED, 40, Element.NECROMANCY, "mind_control", SpellType.ATTACK, 150, EnumAction.NONE, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        block4: {
            EntityLivingBase target;
            block7: {
                block5: {
                    NBTTagCompound entityNBT;
                    block6: {
                        RayTraceResult rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 8.0f * modifiers.get(WizardryItems.range_upgrade));
                        if (rayTrace == null || rayTrace.field_72308_g == null || !(rayTrace.field_72308_g instanceof EntityLivingBase)) break block4;
                        target = (EntityLivingBase)rayTrace.field_72308_g;
                        if (world.field_72995_K) break block5;
                        if (MindControl.canControl(target)) break block6;
                        if (!world.field_72995_K) {
                            caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}));
                        }
                        break block7;
                    }
                    if (!(target instanceof EntityLiving)) break block7;
                    if (!MindControl.findMindControlTarget((EntityLiving)target, (EntityLivingBase)caster, world)) {
                        ((EntityLiving)target).func_70624_b(null);
                    }
                    if ((entityNBT = target.getEntityData()) != null) {
                        entityNBT.func_186854_a(NBT_KEY, caster.func_110124_au());
                    }
                    ((EntityLiving)target).func_70690_d(new PotionEffect(WizardryPotions.mind_control, (int)(600.0f * modifiers.get(WizardryItems.duration_upgrade)), 0));
                    break block7;
                }
                for (int i = 0; i < 10; ++i) {
                    Wizardry.proxy.spawnParticle(WizardryParticleType.DARK_MAGIC, world, target.field_70165_t - 0.25 + world.field_73012_v.nextDouble() * 0.5, target.func_174813_aQ().field_72338_b + (double)target.func_70047_e() - 0.25 + world.field_73012_v.nextDouble() * 0.5, target.field_70161_v - 0.25 + world.field_73012_v.nextDouble() * 0.5, 0.0, 0.0, 0.0, 0, 0.8f, 0.2f, 1.0f);
                    Wizardry.proxy.spawnParticle(WizardryParticleType.DARK_MAGIC, world, target.field_70165_t - 0.25 + world.field_73012_v.nextDouble() * 0.5, target.func_174813_aQ().field_72338_b + (double)target.func_70047_e() - 0.25 + world.field_73012_v.nextDouble() * 0.5, target.field_70161_v - 0.25 + world.field_73012_v.nextDouble() * 0.5, 0.0, 0.0, 0.0, 0, 0.2f, 0.04f, 0.25f);
                }
            }
            target.func_184185_a(WizardrySounds.SPELL_SUMMONING, 1.0f, 1.0f);
            caster.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            if (!world.field_72995_K) {
                if (MindControl.canControl(target)) {
                    NBTTagCompound entityNBT;
                    if (!MindControl.findMindControlTarget((EntityLiving)target, (EntityLivingBase)caster, world)) {
                        ((EntityLiving)target).func_70624_b(null);
                    }
                    if ((entityNBT = target.getEntityData()) != null) {
                        entityNBT.func_186854_a(NBT_KEY, caster.func_110124_au());
                    }
                    ((EntityLiving)target).func_70690_d(new PotionEffect(WizardryPotions.mind_control, (int)(600.0f * modifiers.get(WizardryItems.duration_upgrade)), 0));
                }
            } else {
                for (int i = 0; i < 10; ++i) {
                    Wizardry.proxy.spawnParticle(WizardryParticleType.DARK_MAGIC, world, target.field_70165_t - 0.25 + world.field_73012_v.nextDouble() * 0.5, target.func_174813_aQ().field_72338_b + (double)target.func_70047_e() - 0.25 + world.field_73012_v.nextDouble() * 0.5, target.field_70161_v - 0.25 + world.field_73012_v.nextDouble() * 0.5, 0.0, 0.0, 0.0, 0, 0.8f, 0.2f, 1.0f);
                    Wizardry.proxy.spawnParticle(WizardryParticleType.DARK_MAGIC, world, target.field_70165_t - 0.25 + world.field_73012_v.nextDouble() * 0.5, target.func_174813_aQ().field_72338_b + (double)target.func_70047_e() - 0.25 + world.field_73012_v.nextDouble() * 0.5, target.field_70161_v - 0.25 + world.field_73012_v.nextDouble() * 0.5, 0.0, 0.0, 0.0, 0, 0.2f, 0.04f, 0.25f);
                }
            }
            target.func_184185_a(WizardrySounds.SPELL_SUMMONING, 1.0f, 1.0f);
            caster.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }

    public static boolean canControl(EntityLivingBase target) {
        return target instanceof EntityLiving && target.func_184222_aU() && !(target instanceof INpc) && !(target instanceof EntityEvilWizard);
    }

    public static boolean findMindControlTarget(EntityLiving target, EntityLivingBase caster, World world) {
        List<EntityLivingBase> possibleTargets = WizardryUtilities.getEntitiesWithinRadius(target.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e(), target.field_70165_t, target.field_70163_u, target.field_70161_v, world);
        possibleTargets.remove(target);
        EntityLivingBase newAITarget = null;
        for (EntityLivingBase possibleTarget : possibleTargets) {
            if (!WizardryUtilities.isValidTarget((Entity)caster, (Entity)possibleTarget) || newAITarget != null && !(target.func_70032_d((Entity)possibleTarget) < target.func_70032_d((Entity)newAITarget))) continue;
            newAITarget = possibleTarget;
        }
        if (newAITarget != null) {
            target.func_70624_b(newAITarget);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().func_70644_a(WizardryPotions.mind_control) && event.getEntityLiving() instanceof EntityLiving && ((EntityLiving)event.getEntityLiving()).func_70638_az() != null && !((EntityLiving)event.getEntityLiving()).func_70638_az().func_70089_S()) {
            ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTargetEvent(LivingSetAttackTargetEvent event) {
        if (event.getTarget() == null) {
            return;
        }
        if (event.getEntityLiving().func_70644_a(WizardryPotions.mind_control) && MindControl.canControl(event.getEntityLiving())) {
            NBTTagCompound entityNBT = event.getEntityLiving().getEntityData();
            if (entityNBT != null && entityNBT.func_74764_b("controllingEntityMost")) {
                Entity caster = WizardryUtilities.getEntityByUUID(event.getEntity().field_70170_p, entityNBT.func_186857_a(NBT_KEY));
                if (WizardryUtilities.isValidTarget(caster, (Entity)event.getTarget())) {
                    return;
                }
                if (caster instanceof EntityLivingBase && MindControl.findMindControlTarget((EntityLiving)event.getEntityLiving(), (EntityLivingBase)caster, event.getEntity().field_70170_p)) {
                    return;
                }
            }
            ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
        }
    }
}

