/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class PhaseStep
extends Spell {
    public PhaseStep() {
        super(Tier.ADVANCED, 35, Element.SORCERY, "phase_step", SpellType.UTILITY, 40, EnumAction.NONE, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        RayTraceResult rayTrace = WizardryUtilities.rayTrace(5.0, world, (EntityLivingBase)caster, false);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = new BlockPos(rayTrace.func_178782_a().func_177958_n(), (int)caster.field_70163_u, rayTrace.func_178782_a().func_177952_p());
            int maxThickness = 1 + (int)((modifiers.get(WizardryItems.range_upgrade) - 1.0f) / 0.25f + 0.5f);
            if (rayTrace.field_178784_b.func_176740_k().func_176722_c()) {
                for (int i = 0; i <= maxThickness; ++i) {
                    BlockPos pos1 = pos.func_177967_a(rayTrace.field_178784_b.func_176734_d(), i);
                    if ((WizardryUtilities.isBlockUnbreakable(world, pos1) || WizardryUtilities.isBlockUnbreakable(world, pos1.func_177984_a())) && !Wizardry.settings.teleportThroughUnbreakableBlocks) {
                        return false;
                    }
                    if (world.func_180495_p(pos1).func_185904_a().func_76230_c() || world.func_180495_p(pos1.func_177984_a()).func_185904_a().func_76230_c()) continue;
                    if (!world.field_72995_K) {
                        caster.func_70634_a((double)pos1.func_177958_n() + 0.5, caster.field_70163_u, (double)pos1.func_177952_p() + 0.5);
                    }
                    caster.func_184609_a(hand);
                    return true;
                }
            }
        }
        if (world.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                double dx1 = caster.field_70165_t;
                double dy1 = WizardryUtilities.getPlayerEyesPos(caster) - 1.5 + (double)(2.0f * world.field_73012_v.nextFloat());
                double dz1 = caster.field_70161_v;
                world.func_175688_a(EnumParticleTypes.PORTAL, dx1, dy1, dz1, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, new int[0]);
            }
            WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return false;
    }
}

