/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.projectile.EntityPoisonBomb;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class PoisonBomb
extends Spell {
    public PoisonBomb() {
        super(Tier.APPRENTICE, 15, Element.EARTH, "poison_bomb", SpellType.ATTACK, 25, EnumAction.NONE, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            EntityPoisonBomb poisonbomb = new EntityPoisonBomb(world, (EntityLivingBase)caster, modifiers.get("damage"), modifiers.get(WizardryItems.blast_upgrade));
            world.func_72838_d((Entity)poisonbomb);
        }
        caster.func_184609_a(hand);
        WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187797_fA, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            if (!world.field_72995_K) {
                EntityPoisonBomb poisonbomb = new EntityPoisonBomb(world, (EntityLivingBase)caster, modifiers.get("damage"), modifiers.get(WizardryItems.blast_upgrade));
                poisonbomb.directTowards((Entity)target, 1.5f);
                world.func_72838_d((Entity)poisonbomb);
            }
            caster.func_184609_a(hand);
            caster.func_184185_a(SoundEvents.field_187797_fA, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

