/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.WizardData;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.living.EntitySpiritHorse;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SummonSpiritHorse
extends Spell {
    public SummonSpiritHorse() {
        super(Tier.ADVANCED, 50, Element.EARTH, "summon_spirit_horse", SpellType.MINION, 150, EnumAction.BOW, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        WizardData properties = WizardData.get(caster);
        if (!properties.hasSpiritHorse) {
            if (!world.field_72995_K) {
                BlockPos pos = WizardryUtilities.findNearbyFloorSpace((Entity)caster, 2, 4);
                if (pos == null) {
                    return false;
                }
                EntitySpiritHorse horse = new EntitySpiritHorse(world);
                horse.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                horse.func_110263_g(caster);
                horse.func_110251_o(true);
                world.func_72838_d((Entity)horse);
            }
            properties.hasSpiritHorse = true;
            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_HEAL, 0.7f, world.field_73012_v.nextFloat() * 0.4f + 1.0f);
            return true;
        }
        return false;
    }
}

