/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.EntityArc;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Thunderstorm
extends Spell {
    public Thunderstorm() {
        super(Tier.MASTER, 100, Element.LIGHTNING, "thunderstorm", SpellType.ATTACK, 250, EnumAction.BOW, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (world.func_175710_j(new BlockPos((Entity)caster))) {
            for (int r = 0; r < 10; ++r) {
                double radius = 4.0 + world.field_73012_v.nextDouble() * 6.0 * (double)modifiers.get(WizardryItems.blast_upgrade);
                double angle = world.field_73012_v.nextDouble() * Math.PI * 2.0;
                double x = caster.field_70165_t + radius * Math.cos(angle);
                double z = caster.field_70161_v + radius * Math.sin(angle);
                double y = WizardryUtilities.getNearestFloorLevel(world, new BlockPos(x, caster.field_70163_u, z), 10);
                if (!world.field_72995_K) {
                    EntityLightningBolt entitylightning = new EntityLightningBolt(world, x, y, z, false);
                    world.func_72942_c((Entity)entitylightning);
                }
                double seekerRange = 10.0;
                List<EntityLivingBase> secondaryTargets = WizardryUtilities.getEntitiesWithinRadius(seekerRange, x, y + 1.0, z, world);
                for (EntityLivingBase secondaryTarget : secondaryTargets) {
                    if (!WizardryUtilities.isValidTarget((Entity)caster, (Entity)secondaryTarget)) continue;
                    if (!world.field_72995_K) {
                        EntityArc arc = new EntityArc(world);
                        arc.setEndpointCoords(x, y + 1.0, z, secondaryTarget.field_70165_t, secondaryTarget.field_70163_u + (double)(secondaryTarget.field_70131_O / 2.0f), secondaryTarget.field_70161_v);
                        world.func_72838_d((Entity)arc);
                    } else {
                        for (int j = 0; j < 8; ++j) {
                            Wizardry.proxy.spawnParticle(WizardryParticleType.SPARK, world, secondaryTarget.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, secondaryTarget.func_174813_aQ().field_72338_b + (double)(secondaryTarget.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, secondaryTarget.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, 3);
                            world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, secondaryTarget.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, secondaryTarget.func_174813_aQ().field_72338_b + (double)(secondaryTarget.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, secondaryTarget.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, new int[0]);
                        }
                    }
                    secondaryTarget.func_184185_a(WizardrySounds.SPELL_SPARK, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.5f);
                    secondaryTarget.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.SHOCK), 10.0f * modifiers.get("damage"));
                    List<EntityLivingBase> tertiaryTargets = WizardryUtilities.getEntitiesWithinRadius(seekerRange, secondaryTarget.field_70165_t, secondaryTarget.field_70163_u + (double)(secondaryTarget.field_70131_O / 2.0f), secondaryTarget.field_70161_v, world);
                    for (int j = 0; j < Math.min(tertiaryTargets.size(), 3); ++j) {
                        EntityLivingBase tertiaryTarget = tertiaryTargets.get(j);
                        if (secondaryTargets.contains(tertiaryTarget) || !WizardryUtilities.isValidTarget((Entity)caster, (Entity)tertiaryTarget)) continue;
                        if (!world.field_72995_K) {
                            EntityArc arc = new EntityArc(world);
                            arc.setEndpointCoords(secondaryTarget.field_70165_t, secondaryTarget.field_70163_u + (double)(secondaryTarget.field_70131_O / 2.0f), secondaryTarget.field_70161_v, tertiaryTarget.field_70165_t, tertiaryTarget.field_70163_u + (double)(tertiaryTarget.field_70131_O / 2.0f), tertiaryTarget.field_70161_v);
                            world.func_72838_d((Entity)arc);
                        } else {
                            for (int k = 0; k < 8; ++k) {
                                Wizardry.proxy.spawnParticle(WizardryParticleType.SPARK, world, tertiaryTarget.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, tertiaryTarget.func_174813_aQ().field_72338_b + (double)(tertiaryTarget.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, tertiaryTarget.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, 3);
                                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, tertiaryTarget.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, tertiaryTarget.func_174813_aQ().field_72338_b + (double)(tertiaryTarget.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, tertiaryTarget.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, new int[0]);
                            }
                        }
                        tertiaryTarget.func_184185_a(WizardrySounds.SPELL_SPARK, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.5f);
                        tertiaryTarget.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.SHOCK), 8.0f * modifiers.get("damage"));
                    }
                }
            }
            return true;
        }
        return false;
    }
}

