/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.api.broom;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.ExtendedDamageSource;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.IBroomModifierRegistry;
import org.cyclops.evilcraft.core.broom.PotionEffectBroomCollision;
import org.cyclops.evilcraft.entity.item.EntityBroom;
import org.cyclops.evilcraft.item.BroomConfig;
import org.cyclops.evilcraft.item.DarkSpikeConfig;
import org.cyclops.evilcraft.item.GarmonboziaConfig;
import org.cyclops.evilcraft.item.MaceOfDistortion;

public class BroomModifiers {
    public static final IBroomModifierRegistry REGISTRY = (IBroomModifierRegistry)EvilCraft._instance.getRegistryManager().getRegistry(IBroomModifierRegistry.class);
    public static BroomModifier MODIFIER_COUNT;
    public static BroomModifier SPEED;
    public static BroomModifier ACCELERATION;
    public static BroomModifier MANEUVERABILITY;
    public static BroomModifier LEVITATION;
    public static BroomModifier DAMAGE;
    public static BroomModifier PARTICLES;
    public static BroomModifier FLAME;
    public static BroomModifier SMASH;
    public static BroomModifier BOUNCY;
    public static BroomModifier WITHERER;
    public static BroomModifier HUNGERER;
    public static BroomModifier KAMIKAZE;
    public static BroomModifier WITHERSHIELD;
    public static BroomModifier STURDYNESS;
    public static BroomModifier EFFICIENCY;
    public static BroomModifier SWIMMING;
    public static BroomModifier ICY;

    public static void loadPre() {
        MinecraftForge.EVENT_BUS.register((Object)new BroomModifiers());
        MODIFIER_COUNT = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "modifier_count"), BroomModifier.Type.ADDITIVE, 0.0f, 1.0f, 3, true, TextFormatting.BOLD, Helpers.RGBToInt((int)0, (int)0, (int)0)));
        REGISTRY.overrideDefaultModifierPart(MODIFIER_COUNT, null);
        SPEED = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "speed"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, true, TextFormatting.RED, Helpers.RGBToInt((int)230, (int)20, (int)20)));
        ACCELERATION = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "acceleration"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, true, TextFormatting.DARK_GRAY, Helpers.RGBToInt((int)20, (int)20, (int)20)));
        MANEUVERABILITY = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "maneuverability"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, true, TextFormatting.YELLOW, Helpers.RGBToInt((int)160, (int)160, (int)20)));
        LEVITATION = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "levitation"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, true, TextFormatting.WHITE, Helpers.RGBToInt((int)230, (int)230, (int)230)));
        DAMAGE = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "damage"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, false, TextFormatting.GRAY, Helpers.RGBToInt((int)100, (int)100, (int)100)));
        PARTICLES = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "particles"), BroomModifier.Type.ADDITIVE, 0.0f, 50.0f, 1, false, TextFormatting.LIGHT_PURPLE, Helpers.RGBToInt((int)160, (int)20, (int)160)));
        FLAME = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "flame"), BroomModifier.Type.ADDITIVE, 0.0f, 4.0f, 3, false, TextFormatting.GOLD, Helpers.RGBToInt((int)100, (int)100, (int)0)));
        SMASH = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "smash"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 2, false, TextFormatting.AQUA, Helpers.RGBToInt((int)20, (int)60, (int)60)));
        BOUNCY = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "bouncy"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 3, false, TextFormatting.GREEN, Helpers.RGBToInt((int)20, (int)200, (int)60)));
        WITHERER = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "witherer"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 3, false, TextFormatting.DARK_GRAY, Helpers.RGBToInt((int)20, (int)20, (int)20)));
        HUNGERER = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "hungerer"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 3, false, TextFormatting.DARK_GREEN, Helpers.RGBToInt((int)20, (int)120, (int)20)));
        KAMIKAZE = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "kamikaze"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 3, false, TextFormatting.DARK_GREEN, Helpers.RGBToInt((int)20, (int)120, (int)20)));
        WITHERSHIELD = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "withershield"), BroomModifier.Type.ADDITIVE, 0.0f, 5.0f, 4, false, TextFormatting.DARK_BLUE, Helpers.RGBToInt((int)20, (int)20, (int)120)));
        STURDYNESS = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "sturdyness"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, false, TextFormatting.GRAY, Helpers.RGBToInt((int)100, (int)100, (int)100)));
        EFFICIENCY = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "efficiency"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 3, false, TextFormatting.DARK_RED, Helpers.RGBToInt((int)92, (int)29, (int)29)));
        SWIMMING = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "swimming"), BroomModifier.Type.ADDITIVE, 0.0f, 100.0f, 3, false, TextFormatting.AQUA, Helpers.RGBToInt((int)150, (int)150, (int)235)));
        ICY = REGISTRY.registerModifier(new BroomModifier(new ResourceLocation("evilcraft", "icy"), BroomModifier.Type.ADDITIVE, 0.0f, 10.0f, 3, false, TextFormatting.WHITE, Helpers.RGBToInt((int)220, (int)220, (int)240)));
        DAMAGE.addCollisionListener(new BroomModifier.ICollisionListener(){

            @Override
            public void onCollide(EntityBroom broom, Entity entity, float modifierValue) {
                float damage = modifierValue * (float)broom.getLastPlayerSpeed() / 50.0f;
                if (damage > 0.0f) {
                    entity.func_70097_a((DamageSource)ExtendedDamageSource.broomDamage((EntityLivingBase)broom.func_184179_bs()), damage);
                }
            }
        });
        FLAME.addCollisionListener(new BroomModifier.ICollisionListener(){

            @Override
            public void onCollide(EntityBroom broom, Entity entity, float modifierValue) {
                if (modifierValue > 0.0f) {
                    entity.func_70015_d((int)modifierValue);
                }
            }
        });
        SMASH.addTickListener(new BroomModifier.ITickListener(){

            @Override
            public void onTick(EntityBroom broom, float modifierValue) {
                EntityPlayer player;
                double pitch = (double)(broom.field_70125_A + 90.0f) * Math.PI / 180.0;
                double yaw = (double)(broom.field_70177_z + 90.0f) * Math.PI / 180.0;
                double x = Math.sin(pitch) * Math.cos(yaw);
                double z = Math.sin(pitch) * Math.sin(yaw);
                double y = Math.cos(pitch);
                double r = -0.1;
                BlockPos blockpos = new BlockPos(broom.func_174813_aQ().field_72340_a + x + r, broom.func_174813_aQ().field_72338_b + y + r, broom.func_174813_aQ().field_72339_c + z + r);
                BlockPos blockpos1 = new BlockPos(broom.func_174813_aQ().field_72336_d + x - r, broom.func_174813_aQ().field_72337_e + y - r + 1.0, broom.func_174813_aQ().field_72334_f + z - r);
                World world = broom.field_70170_p;
                float maxHardness = modifierValue;
                float toughnessModifier = Math.min(1.0f, 0.5f + broom.getModifier(STURDYNESS) / (STURDYNESS.getMaxTierValue() * 1.5f) / 2.0f);
                EntityLivingBase ridingEntity = broom.func_184179_bs() instanceof EntityLivingBase ? (EntityLivingBase)broom.func_184179_bs() : null;
                EntityPlayer entityPlayer = player = broom.func_184179_bs() instanceof EntityPlayer ? (EntityPlayer)broom.func_184179_bs() : null;
                if (world.func_175707_a(blockpos, blockpos1)) {
                    for (int i = blockpos.func_177958_n(); i <= blockpos1.func_177958_n(); ++i) {
                        for (int j = blockpos.func_177956_o(); j <= blockpos1.func_177956_o(); ++j) {
                            for (int k = blockpos.func_177952_p(); k <= blockpos1.func_177952_p(); ++k) {
                                float hardness;
                                BlockPos pos = new BlockPos(i, j, k);
                                IBlockState blockState = world.func_180495_p(pos);
                                Block block = blockState.func_177230_c();
                                if (blockState.func_177230_c().isAir(blockState, (IBlockAccess)world, pos) || !broom.canConsume(BroomConfig.bloodUsageBlockBreak, ridingEntity) || !((hardness = blockState.func_185887_b(world, pos)) > 0.0f) || !(hardness <= maxHardness)) continue;
                                broom.consume(BroomConfig.bloodUsageBlockBreak, ridingEntity);
                                if (player == null) {
                                    world.func_175655_b(pos, true);
                                } else if (!broom.field_70170_p.field_72995_K) {
                                    EntityPlayerMP playerMp = (EntityPlayerMP)player;
                                    int expToDrop = ForgeHooks.onBlockBreakEvent((World)world, (GameType)playerMp.field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos);
                                    if (expToDrop >= 0) {
                                        block.func_176208_a(world, pos, blockState, player);
                                        if (block.removedByPlayer(blockState, world, pos, player, true)) {
                                            block.func_176206_d(world, pos, blockState);
                                            block.func_180657_a(world, player, pos, blockState, world.func_175625_s(pos), null);
                                            block.func_180637_b(world, pos, expToDrop);
                                        }
                                        playerMp.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
                                    }
                                } else if (Minecraft.func_71410_x().field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK) {
                                    world.func_175669_a(2001, pos, Block.func_176210_f((IBlockState)blockState));
                                    if (block.removedByPlayer(blockState, world, pos, player, true)) {
                                        block.func_176206_d(world, pos, blockState);
                                    }
                                    Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
                                }
                                broom.setLastPlayerSpeed(broom.getLastPlayerSpeed() * (double)toughnessModifier);
                            }
                        }
                    }
                }
            }
        });
        BOUNCY.addCollisionListener(new BroomModifier.ICollisionListener(){

            @Override
            public void onCollide(EntityBroom broom, Entity entity, float modifierValue) {
                double dz;
                double dy;
                double dx;
                double d;
                float power = modifierValue * (float)broom.getLastPlayerSpeed() / 20.0f;
                if (power > 0.0f && (d = (double)MathHelper.func_76133_a((double)((dx = entity.field_70165_t - broom.field_70165_t) * dx + (dy = entity.field_70163_u + (double)entity.func_70047_e() - broom.field_70163_u) * dy + (dz = entity.field_70161_v - broom.field_70161_v) * dz))) != 0.0) {
                    entity.field_70159_w += (dx /= d) * (double)power;
                    entity.field_70181_x += (dy /= d) * (double)power;
                    entity.field_70179_y += (dz /= d) * (double)power;
                    if (broom.field_70170_p.field_72995_K) {
                        MaceOfDistortion.showEntityDistored(broom.field_70170_p, null, entity, (int)(power / 10.0f));
                    }
                }
            }
        });
        WITHERER.addCollisionListener(new PotionEffectBroomCollision(MobEffects.field_82731_v));
        HUNGERER.addCollisionListener(new PotionEffectBroomCollision(MobEffects.field_76438_s));
        KAMIKAZE.addCollisionListener(new BroomModifier.ICollisionListener(){

            @Override
            public void onCollide(EntityBroom broom, Entity entity, float modifierValue) {
                World world = broom.field_70170_p;
                float power = modifierValue * (float)broom.getLastPlayerSpeed() / 5.0f;
                if (power > 0.0f && broom.func_184179_bs() != null) {
                    broom.func_184210_p();
                    world.func_72876_a(null, broom.field_70165_t, broom.field_70163_u, broom.field_70161_v, power, true);
                }
            }
        });
        ICY.addCollisionListener(new PotionEffectBroomCollision(MobEffects.field_76421_d, 2));
    }

    public static void loadPost() {
        REGISTRY.registerModifiersItem(MODIFIER_COUNT, 1.0f, new ItemStack(Items.field_151156_bN));
        REGISTRY.registerModifiersItem(MODIFIER_COUNT, 1.0f, new ItemStack(GarmonboziaConfig._instance.getItemInstance()));
        REGISTRY.registerModifiersItem(SPEED, 1.0f, new ItemStack(Items.field_151137_ax));
        REGISTRY.registerModifiersItem(SPEED, 9.0f, new ItemStack(Blocks.field_150451_bX));
        REGISTRY.registerModifiersItem(ACCELERATION, 1.0f, new ItemStack(Items.field_151044_h));
        REGISTRY.registerModifiersItem(ACCELERATION, 9.0f, new ItemStack(Blocks.field_150402_ci));
        REGISTRY.registerModifiersItem(MANEUVERABILITY, 2.0f, new ItemStack(Items.field_151114_aO));
        REGISTRY.registerModifiersItem(MANEUVERABILITY, 8.0f, new ItemStack(Blocks.field_150426_aN));
        REGISTRY.registerModifiersItem(LEVITATION, 1.0f, new ItemStack(Items.field_151008_G));
        REGISTRY.registerModifiersItem(DAMAGE, 2.0f, new ItemStack(DarkSpikeConfig._instance.getItemInstance()));
        REGISTRY.registerModifiersItem(DAMAGE, 1.0f, new ItemStack(Items.field_151128_bU));
        REGISTRY.registerModifiersItem(PARTICLES, 1.0f, new ItemStack(Items.field_151016_H));
        REGISTRY.registerModifiersItem(FLAME, 1.0f, new ItemStack(Items.field_151065_br));
        REGISTRY.registerModifiersItem(SMASH, 1.0f, new ItemStack(Items.field_151035_b));
        REGISTRY.registerModifiersItem(SMASH, 5.0f, new ItemStack(Items.field_151046_w));
        REGISTRY.registerModifiersItem(BOUNCY, 1.0f, new ItemStack(Items.field_151123_aH));
        REGISTRY.registerModifiersItem(BOUNCY, 9.0f, new ItemStack(Blocks.field_180399_cE));
        BroomModifiers.registerModifierOredictItem(STURDYNESS, 1.0f, "stone");
        REGISTRY.registerModifiersItem(STURDYNESS, 10.0f, new ItemStack(Blocks.field_150343_Z));
        BroomModifiers.registerModifierOredictItem(EFFICIENCY, 1.0f, "gemDarkPower");
        REGISTRY.registerModifiersItem(SWIMMING, 1.0f, new ItemStack(Items.field_179562_cC));
        REGISTRY.registerModifiersItem(SWIMMING, 4.0f, new ItemStack(Blocks.field_180397_cI, 1, 0));
        REGISTRY.registerModifiersItem(SWIMMING, 9.0f, new ItemStack(Blocks.field_180397_cI, 1, 1));
        REGISTRY.registerModifiersItem(ICY, 1.0f, new ItemStack(Blocks.field_150432_aD, 1, 0));
        REGISTRY.registerModifiersItem(ICY, 5.0f, new ItemStack(Blocks.field_150403_cj, 1, 0));
        EvilCraft.clog(String.format("%s Broom modifiers can be applied!", REGISTRY.getModifiers().size()));
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        EntityBroom broom;
        float modifierValue;
        if (event.getEntityLiving() != null && event.getEntityLiving().func_184187_bx() instanceof EntityBroom && event.getSource().func_76364_f() instanceof IProjectile && (modifierValue = (broom = (EntityBroom)event.getEntityLiving().func_184187_bx()).getModifier(WITHERSHIELD)) > 0.0f && modifierValue > (float)broom.field_70170_p.field_73012_v.nextInt((int)WITHERSHIELD.getMaxTierValue())) {
            event.setCanceled(true);
        }
    }

    public static void registerModifierOredictItem(BroomModifier modifier, float value, String name) {
        for (ItemStack itemStack : OreDictionary.getOres((String)name)) {
            REGISTRY.registerModifiersItem(modifier, value, itemStack);
        }
    }
}

