/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.block.property.UnlistedProperty;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.evilcraft.client.render.model.ModelDisplayStand;
import org.cyclops.evilcraft.tileentity.TileDisplayStand;

public class DisplayStand
extends ConfigurableBlockContainer
implements IInformationProvider {
    private static final String NBT_TYPE = "displayStandType";
    @BlockProperty
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    @BlockProperty
    public static final PropertyBool AXIS_X = PropertyBool.func_177716_a((String)"axis_x");
    @BlockProperty
    public static final IUnlistedProperty<EnumFacing.AxisDirection> DIRECTION = new UnlistedProperty("direction", EnumFacing.AxisDirection.class);
    @BlockProperty
    public static final IUnlistedProperty<ItemStack> TYPE = new UnlistedProperty("blocktype", ItemStack.class);
    private static DisplayStand _instance = null;
    public static final Map<EnumFacing, AxisAlignedBB> FACING_BOUNDS = ImmutableMap.builder().put((Object)EnumFacing.DOWN, (Object)new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.5, 0.625)).put((Object)EnumFacing.UP, (Object)new AxisAlignedBB(0.375, 0.5, 0.375, 0.625, 1.0, 0.625)).put((Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.0, 0.375, 0.375, 0.5, 0.625, 0.625)).put((Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.5, 0.375, 0.375, 1.0, 0.625, 0.625)).put((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 0.5)).put((Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.375, 0.375, 0.5, 0.625, 0.625, 1.0)).build();

    public static DisplayStand getInstance() {
        return _instance;
    }

    public DisplayStand(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151575_d, TileDisplayStand.class);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_149721_r(IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(IBlockState blockState) {
        return false;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState blockState = (IExtendedBlockState)state;
        TileDisplayStand tile = (TileDisplayStand)((Object)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileDisplayStand.class));
        if (tile != null) {
            blockState = blockState.withProperty(DIRECTION, (Object)tile.getDirection());
            if (tile.getDisplayStandType() != null) {
                blockState = blockState.withProperty(TYPE, (Object)tile.getDisplayStandType());
            }
        }
        return blockState;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FACING_BOUNDS.get(BlockHelpers.getSafeBlockStateProperty((IBlockState)state, (IProperty)FACING, (Object)EnumFacing.DOWN));
    }

    public boolean func_149740_M(IBlockState blockState) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos blockPos) {
        TileDisplayStand tile = (TileDisplayStand)((Object)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)blockPos, TileDisplayStand.class));
        if (tile != null && tile.func_70301_a(0) != null) {
            return 15;
        }
        return 0;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState blockState = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        blockState = blockState.func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
        EnumFacing playerFacing = placer.func_174811_aO();
        boolean axisX = facing.func_176734_d() == EnumFacing.DOWN || facing.func_176734_d() == EnumFacing.UP ? playerFacing.func_176740_k() == EnumFacing.Axis.X : playerFacing.func_176740_k() != EnumFacing.Axis.X && playerFacing.func_176740_k() != EnumFacing.Axis.Z;
        blockState = blockState.func_177226_a((IProperty)AXIS_X, (Comparable)Boolean.valueOf(axisX));
        return blockState;
    }

    public void func_180633_a(World world, BlockPos blockPos, IBlockState blockState, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, blockPos, blockState, entity, stack);
        TileDisplayStand tile = (TileDisplayStand)((Object)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)blockPos, TileDisplayStand.class));
        if (tile != null) {
            tile.setDirection(entity.func_174811_aO().func_176743_c());
        }
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileDisplayStand tile = (TileDisplayStand)((Object)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileDisplayStand.class));
        if (tile != null) {
            IBlockState blockState = world.func_180495_p(pos);
            if (tile.getDirection() == EnumFacing.AxisDirection.POSITIVE) {
                if (((Boolean)blockState.func_177229_b((IProperty)AXIS_X)).booleanValue()) {
                    world.func_175656_a(pos, blockState.func_177226_a((IProperty)AXIS_X, (Comparable)Boolean.valueOf(false)));
                    tile.setDirection(EnumFacing.AxisDirection.POSITIVE);
                } else {
                    world.func_175656_a(pos, blockState.func_177226_a((IProperty)AXIS_X, (Comparable)Boolean.valueOf(true)));
                    tile.setDirection(EnumFacing.AxisDirection.NEGATIVE);
                }
            } else if (((Boolean)blockState.func_177229_b((IProperty)AXIS_X)).booleanValue()) {
                world.func_175656_a(pos, blockState.func_177226_a((IProperty)AXIS_X, (Comparable)Boolean.valueOf(false)));
                tile.setDirection(EnumFacing.AxisDirection.NEGATIVE);
            } else {
                world.func_175656_a(pos, blockState.func_177226_a((IProperty)AXIS_X, (Comparable)Boolean.valueOf(true)));
                tile.setDirection(EnumFacing.AxisDirection.POSITIVE);
            }
        }
        return super.rotateBlock(world, pos, axis);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (ItemStack plankWoodStack : OreDictionary.getOres((String)"plankWood")) {
            if (!(plankWoodStack.func_77973_b() instanceof ItemBlock)) continue;
            int plankWoodMeta = plankWoodStack.func_77952_i();
            if (plankWoodMeta == Short.MAX_VALUE) {
                ArrayList plankWoodSubItems = Lists.newArrayList();
                plankWoodStack.func_77973_b().func_150895_a(plankWoodStack.func_77973_b(), null, (List)plankWoodSubItems);
                for (ItemStack plankWoodSubItem : plankWoodSubItems) {
                    IBlockState plankWoodBlockState = BlockHelpers.getBlockStateFromItemStack((ItemStack)plankWoodSubItem);
                    list.add(this.getTypedDisplayStandItem(plankWoodBlockState));
                }
                continue;
            }
            IBlockState plankWoodBlockState = BlockHelpers.getBlockStateFromItemStack((ItemStack)plankWoodStack);
            list.add(this.getTypedDisplayStandItem(plankWoodBlockState));
        }
    }

    public ItemStack getTypedDisplayStandItem(IBlockState blockState) {
        Block block = blockState.func_177230_c();
        int meta = blockState.func_177230_c().func_176201_c(blockState);
        ItemStack itemStack = new ItemStack((Block)this);
        NBTTagCompound tag = ItemStackHelpers.getSafeTagCompound((ItemStack)itemStack);
        ItemStack blockStack = new ItemStack(block, 1, meta);
        NBTTagCompound blockTag = new NBTTagCompound();
        blockStack.func_77955_b(blockTag);
        tag.func_74782_a(NBT_TYPE, (NBTBase)blockTag);
        return itemStack;
    }

    public ItemStack getDisplayStandType(ItemStack displayStandStack) {
        NBTTagCompound tag = ItemStackHelpers.getSafeTagCompound((ItemStack)displayStandStack);
        if (tag.func_74764_b(NBT_TYPE)) {
            NBTTagCompound blockTag = tag.func_74775_l(NBT_TYPE);
            return ItemStack.func_77949_a((NBTTagCompound)blockTag);
        }
        return null;
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack() != null && event.getItemStack().hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && event.getWorld().func_180495_p(event.getPos()).func_177230_c() == this) {
            event.setUseBlock(Event.Result.ALLOW);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack itemStack, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileDisplayStand tile = (TileDisplayStand)((Object)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileDisplayStand.class));
        if (tile != null) {
            ItemStack tileStack = tile.func_70301_a(0);
            if ((itemStack == null || ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)tileStack) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)tileStack) && tileStack.field_77994_a < tileStack.func_77976_d()) && tileStack != null) {
                if (itemStack != null) {
                    tileStack.field_77994_a += itemStack.field_77994_a;
                }
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, tileStack);
                tile.func_70299_a(0, null);
                tile.sendUpdate();
                return true;
            }
            if (itemStack != null && tile.func_70301_a(0) == null) {
                tile.func_70299_a(0, itemStack.func_77979_a(1));
                if (itemStack.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                tile.sendUpdate();
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        for (EnumFacing facing : FACING.func_177700_c()) {
            for (Boolean axisX : AXIS_X.func_177700_c()) {
                String blockVariant = String.format("%s=%s,%s=%s", AXIS_X.func_177701_a(), AXIS_X.func_177702_a(axisX), FACING.func_177701_a(), FACING.func_177702_a((Enum)facing));
                this.bakeVariantModel(event, blockVariant, axisX == false);
            }
        }
        this.bakeVariantModel(event, "inventory", false);
    }

    protected void bakeVariantModel(ModelBakeEvent event, String variant, boolean rotated) {
        ModelResourceLocation modelVariantLocation = new ModelResourceLocation("evilcraft:displayStand", variant);
        try {
            ResourceLocation modelLocation = new ResourceLocation("evilcraft", "block/displayStand" + (rotated ? "_rotated" : ""));
            IBakedModel originalBakedModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)modelVariantLocation);
            IModel model = ModelLoaderRegistry.getModel((ResourceLocation)modelLocation);
            if (model instanceof IRetexturableModel && originalBakedModel instanceof IPerspectiveAwareModel) {
                event.getModelRegistry().func_82595_a((Object)modelVariantLocation, (Object)new ModelDisplayStand((IPerspectiveAwareModel)originalBakedModel, (IRetexturableModel)model));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getInfo(ItemStack itemStack) {
        ItemStack blockType = this.getDisplayStandType(itemStack);
        if (blockType != null) {
            return blockType.func_82833_r();
        }
        return "";
    }

    public void provideInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
    }
}

