/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.cyclops.cyclopscore.client.model.DelegatingChildDynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.evilcraft.block.BloodStainedBlock;

public class ModelBloodStainedBlock
extends DelegatingChildDynamicItemAndBlockModel {
    private final TextureAtlasSprite overlayIcon;
    private final IBlockState innerBlockState;

    public ModelBloodStainedBlock() {
        super(null);
        this.overlayIcon = null;
        this.innerBlockState = null;
    }

    public ModelBloodStainedBlock(IBakedModel baseModel, TextureAtlasSprite overlayIcon, boolean item, IBlockState blockState, EnumFacing facing, long rand, IBlockState innerBlockState) {
        super(baseModel, blockState, facing, rand);
        this.overlayIcon = overlayIcon;
        this.innerBlockState = innerBlockState;
    }

    public List<BakedQuad> getGeneralQuads() {
        ArrayList quads;
        try {
            quads = Lists.newArrayList((Iterable)this.baseModel.func_188616_a(this.innerBlockState, this.getRenderingSide(), this.rand));
        }
        catch (Exception e) {
            quads = Lists.newArrayList();
        }
        if (this.facing == EnumFacing.UP || this.facing == null) {
            ModelBloodStainedBlock.addBakedQuad((List)quads, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.01f, (TextureAtlasSprite)this.overlayIcon, (EnumFacing)EnumFacing.UP);
        }
        return quads;
    }

    public IBakedModel handleBlockState(IBlockState state, EnumFacing side, long rand) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        IBlockState blockState = (IBlockState)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)extendedBlockState, BloodStainedBlock.INNERBLOCK, null);
        BlockPos pos = (BlockPos)BlockHelpers.getSafeBlockStateProperty((IExtendedBlockState)extendedBlockState, BloodStainedBlock.POS, null);
        TextureAtlasSprite overlayIcon = this.getIcon(pos);
        IBakedModel baseModel = RenderHelpers.getBakedModel((IBlockState)blockState);
        return new ModelBloodStainedBlock(baseModel, overlayIcon, false, state, this.facing, rand, blockState);
    }

    public IBakedModel handleItemState(ItemStack stack, World world, EntityLivingBase entity) {
        return this;
    }

    protected TextureAtlasSprite getIcon(BlockPos pos) {
        TextureAtlasSprite[] icons = new TextureAtlasSprite[]{BloodStainedBlock.getInstance().icon0, BloodStainedBlock.getInstance().icon1, BloodStainedBlock.getInstance().icon2};
        return icons[pos == null ? 0 : Math.abs(pos.hashCode()) % 3];
    }

    public TextureAtlasSprite func_177554_e() {
        return RenderHelpers.getBakedModel((IBlockState)Blocks.field_150348_b.func_176223_P()).func_177554_e();
    }
}

