/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.degradation.effect;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.api.degradation.IDegradable;
import org.cyclops.evilcraft.block.NetherfishSpawn;
import org.cyclops.evilcraft.block.NetherfishSpawnConfig;
import org.cyclops.evilcraft.core.config.extendedconfig.DegradationEffectConfig;
import org.cyclops.evilcraft.core.degradation.StochasticDegradationEffect;

public class TerraformDegradation
extends StochasticDegradationEffect {
    private static TerraformDegradation _instance = null;
    private static Map<Block, Map<IBlockState, Integer>> TERRAFORMATIONS = Maps.newHashMap();
    private static final double CHANCE = 0.1;
    private static Random random = new Random();

    public static TerraformDegradation getInstance() {
        return _instance;
    }

    private static final void putReplacement(Block key, IBlockState value) {
        TerraformDegradation.putReplacement(key, value, 0);
    }

    private static final void putReplacement(Block key, IBlockState value, int chance) {
        Map<IBlockState, Integer> mapValue = TERRAFORMATIONS.get(key);
        if (mapValue == null) {
            mapValue = new HashMap<IBlockState, Integer>();
            TERRAFORMATIONS.put(key, mapValue);
        }
        mapValue.put(value, chance);
    }

    public TerraformDegradation(ExtendedConfig<DegradationEffectConfig> eConfig) {
        super(eConfig, 0.1);
    }

    @Override
    public void runClientSide(IDegradable degradable) {
    }

    protected IBlockState getReplacement(Block block) {
        Object[] keys;
        IBlockState holder;
        Integer chance;
        Map<IBlockState, Integer> mapValue = TERRAFORMATIONS.get(block);
        if (mapValue == null) {
            mapValue = TERRAFORMATIONS.get(null);
        }
        if (mapValue != null && ((chance = mapValue.get(holder = (IBlockState)(keys = mapValue.keySet().toArray())[random.nextInt(keys.length)])) == null || chance == 0 || random.nextInt(chance) == 0)) {
            return holder;
        }
        return null;
    }

    @Override
    public void runServerSide(IDegradable degradable) {
        BlockPos blockPos;
        World world = degradable.getDegradationWorld();
        Block block = world.func_180495_p(blockPos = LocationHelpers.getRandomPointInSphere((BlockPos)degradable.getLocation(), (int)degradable.getRadius())).func_177230_c();
        IBlockState replace = this.getReplacement(block);
        if (replace != null && !degradable.getLocation().equals((Object)blockPos) && world.func_175625_s(blockPos) == null) {
            if (replace.func_177230_c() == null) {
                world.func_175698_g(blockPos);
            } else if (replace.func_185887_b(world, blockPos) > 0.0f) {
                world.func_180501_a(blockPos, replace, 3);
            }
        }
    }

    static {
        TerraformDegradation.putReplacement(null, Blocks.field_150347_e.func_176223_P(), 30);
        TerraformDegradation.putReplacement(Blocks.field_150348_b, Blocks.field_150347_e.func_176223_P());
        TerraformDegradation.putReplacement(Blocks.field_150347_e, Blocks.field_150346_d.func_176223_P(), 10);
        TerraformDegradation.putReplacement(Blocks.field_150347_e, Blocks.field_150353_l.func_176223_P(), 30);
        TerraformDegradation.putReplacement(Blocks.field_150402_ci, Blocks.field_150484_ah.func_176223_P(), 10000);
        TerraformDegradation.putReplacement(Blocks.field_150346_d, Blocks.field_150424_aL.func_176223_P(), 30);
        TerraformDegradation.putReplacement((Block)Blocks.field_150349_c, Blocks.field_150424_aL.func_176223_P(), 20);
        TerraformDegradation.putReplacement((Block)Blocks.field_150391_bh, Blocks.field_150424_aL.func_176223_P(), 5);
        TerraformDegradation.putReplacement(Blocks.field_150346_d, Blocks.field_150354_m.func_176223_P());
        TerraformDegradation.putReplacement((Block)Blocks.field_150349_c, Blocks.field_150354_m.func_176223_P());
        TerraformDegradation.putReplacement((Block)Blocks.field_150391_bh, Blocks.field_150354_m.func_176223_P());
        TerraformDegradation.putReplacement(Blocks.field_150346_d, Blocks.field_150435_aG.func_176223_P(), 20);
        TerraformDegradation.putReplacement((Block)Blocks.field_150349_c, Blocks.field_150354_m.func_176223_P(), 20);
        TerraformDegradation.putReplacement((Block)Blocks.field_150391_bh, Blocks.field_150354_m.func_176223_P(), 20);
        if (Configs.isEnabled(NetherfishSpawnConfig.class)) {
            TerraformDegradation.putReplacement(Blocks.field_150424_aL, NetherfishSpawn.getInstance().func_176203_a(NetherfishSpawn.getInstance().getMetadataFromBlock(Blocks.field_150424_aL)), 50);
        }
        TerraformDegradation.putReplacement((Block)Blocks.field_150354_m, null);
        TerraformDegradation.putReplacement((Block)Blocks.field_150355_j, null);
    }
}

