/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.fluid;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.capability.wrappers.FluidContainerItemWrapper;
import org.cyclops.evilcraft.core.fluid.SimulatedFluidStack;

public class FluidContainerItemWrapperWithSimulation
extends FluidContainerItemWrapper {
    public FluidContainerItemWrapperWithSimulation(IFluidContainerItem handler, ItemStack container) {
        super(handler, container);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource instanceof SimulatedFluidStack) {
            doFill = false;
        }
        return super.fill(resource, doFill);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack drained = super.drain(maxDrain, doDrain);
        if (doDrain || drained == null || drained.amount == 0) {
            return drained;
        }
        return new SimulatedFluidStack(drained.getFluid(), drained.amount);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource instanceof SimulatedFluidStack) {
            doDrain = false;
        }
        FluidStack drained = super.drain(resource, doDrain);
        if (doDrain || drained == null || drained.amount == 0) {
            return drained;
        }
        return new SimulatedFluidStack(drained.getFluid(), drained.amount);
    }
}

