/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.fluid;

import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConverter;

public class ImplicitFluidConversionTank
extends SingleUseTank {
    private ImplicitFluidConverter converter;

    public ImplicitFluidConversionTank(String name, int capacity, CyclopsTileEntity tile, ImplicitFluidConverter converter) {
        super(name, capacity, tile);
        this.converter = converter;
    }

    public int fill(FluidStack resource, boolean doFill) {
        FluidStack converted = this.converter.convert(resource);
        if (converted == null) {
            return 0;
        }
        double ratio = resource != null ? this.converter.getRatio(resource.getFluid()) : 1.0;
        return (int)Math.ceil((double)super.fill(converted, doFill) / ratio);
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return super.canFillFluidType(fluid) && (fluid == null || fluid.getFluid() == this.converter.getTarget() || this.converter.canConvert(fluid.getFluid()));
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return super.canDrainFluidType(fluid) && (fluid == null || fluid.getFluid() == this.converter.getTarget() || this.converter.canConvert(fluid.getFluid()));
    }
}

