/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.helper;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.fluid.Blood;

public class ItemHelpers {
    private static final int MB_FILL_PERTICK = GeneralConfig.mbFlowRate;
    private static ItemStack bloodBucket = null;

    public static boolean isActivated(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74767_n("enabled");
    }

    public static void toggleActivation(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.func_77982_d(tag);
        }
        tag.func_74757_a("enabled", !ItemHelpers.isActivated(itemStack));
    }

    public static int getNBTInt(ItemStack itemStack, String tag) {
        if (itemStack == null || itemStack.func_77978_p() == null) {
            return 0;
        }
        return itemStack.func_77978_p().func_74762_e(tag);
    }

    public static void setNBTInt(ItemStack itemStack, int integer, String tag) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            itemStack.func_77982_d(tagCompound);
        }
        tagCompound.func_74768_a(tag, integer);
    }

    public static void updateAutoFill(IFluidHandler toDrain, ItemStack itemStack, World world, Entity entity) {
        FluidStack tickFluid;
        if (entity instanceof EntityPlayer && !world.field_72995_K && (tickFluid = toDrain.drain(Integer.MAX_VALUE, false)) != null && tickFluid.amount > 0) {
            EntityPlayer player = (EntityPlayer)entity;
            for (EnumHand hand : EnumHand.values()) {
                ItemStack held = player.func_184586_b(hand);
                ItemStack filled = ItemHelpers.tryFillContainerForPlayer(toDrain, itemStack, held, tickFluid, player);
                if (filled == null) continue;
                player.func_184611_a(hand, filled);
            }
        }
    }

    public static ItemStack tryFillContainerForPlayer(IFluidHandler toDrain, ItemStack itemStack, ItemStack toFill, FluidStack tickFluid, EntityPlayer player) {
        if (toFill != null && toFill != itemStack && FluidUtil.getFluidHandler((ItemStack)toFill) != null && player.func_184605_cv() == 0) {
            return FluidUtil.tryFillContainer((ItemStack)toFill, (IFluidHandler)toDrain, (int)Math.min(MB_FILL_PERTICK, tickFluid.amount), (EntityPlayer)player, (boolean)true);
        }
        return null;
    }

    public static ItemStack getBloodBucket() {
        if (bloodBucket == null) {
            bloodBucket = UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)Blood.getInstance());
        }
        return bloodBucket;
    }
}

