/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.FluidContainerItemWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.item.ItemBlockNBT;
import org.cyclops.cyclopscore.tileentity.TankInventoryTileEntity;
import org.cyclops.evilcraft.core.block.IBlockTank;
import org.cyclops.evilcraft.core.helper.ItemHelpers;

public class ItemBlockFluidContainer
extends ItemBlockNBT
implements IFluidContainerItem {
    private IBlockTank block;

    public ItemBlockFluidContainer(Block block) {
        super(block);
        this.func_77627_a(false);
        this.block = (IBlockTank)block;
    }

    public IBlockTank getBlockTank() {
        return this.block;
    }

    public FluidStack getFluid(ItemStack container) {
        String key = this.block.getTankNBTName();
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b(key)) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l(key));
    }

    protected void setFluid(ItemStack container, FluidStack fluidStack) {
        String key = this.block.getTankNBTName();
        if (fluidStack == null || fluidStack.amount <= 0) {
            container.func_77978_p().func_82580_o(key);
            if (container.func_77978_p().func_82582_d()) {
                container.func_77982_d(null);
            }
        } else {
            if (container.func_77978_p() == null) {
                container.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound fluidTag = container.func_77978_p().func_74775_l(key);
            fluidStack.writeToNBT(fluidTag);
            fluidTag.func_82580_o("Empty");
            container.func_77978_p().func_74782_a(key, (NBTBase)fluidTag);
        }
    }

    public int getCapacity(ItemStack container) {
        return this.block.getTankCapacity(container);
    }

    public void setCapacity(ItemStack container, int capacity) {
        this.block.setTankCapacity(container, capacity);
    }

    protected void readAdditionalInfo(TileEntity tile, ItemStack itemStack) {
        super.readAdditionalInfo(tile, itemStack);
        if (tile instanceof TankInventoryTileEntity) {
            TankInventoryTileEntity tankTile = (TankInventoryTileEntity)tile;
            tankTile.getTank().setCapacity(this.getCapacity(itemStack));
        }
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        int capacity = this.getCapacity(container);
        if (resource == null) {
            return 0;
        }
        FluidStack stack = this.getFluid(container);
        if (!doFill) {
            if (stack == null) {
                return Math.min(capacity, resource.amount);
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(capacity - stack.amount, resource.amount);
        }
        if (stack == null) {
            stack = resource.copy();
            stack.amount = 0;
        }
        if (!resource.isFluidEqual(stack)) {
            return 0;
        }
        int filled = capacity - stack.amount;
        if (resource.amount < filled) {
            stack.amount = Helpers.addSafe((int)stack.amount, (int)resource.amount);
            filled = resource.amount;
        } else {
            stack.amount = capacity;
        }
        this.setFluid(container, stack);
        return filled;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        FluidStack stack = this.getFluid(container);
        if (stack == null) {
            return null;
        }
        int currentAmount = stack.amount;
        stack.amount = Math.min(stack.amount, maxDrain);
        if (doDrain) {
            FluidStack newStack = stack.copy();
            newStack.amount = currentAmount - stack.amount;
            this.setFluid(container, newStack);
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        if (this.block.isActivatable()) {
            return new ActionResult(EnumActionResult.PASS, (Object)this.block.toggleActivation(itemStack, world, player));
        }
        return super.func_77659_a(itemStack, world, player, hand);
    }

    protected void autofill(IFluidHandler source, ItemStack itemStack, World world, Entity entity) {
        ItemHelpers.updateAutoFill(source, itemStack, world, entity);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (this.block.isActivatable() && this.block.isActivated(itemStack, world, entity)) {
            this.autofill(FluidUtil.getFluidHandler((ItemStack)itemStack), itemStack, world, entity);
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        if (this.block.isActivatable()) {
            L10NHelpers.addStatusInfo((List)list, (boolean)this.block.isActivated(itemStack, entityPlayer.field_70170_p, (Entity)entityPlayer), (String)(this.func_77658_a() + ".info.autoSupply"));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b() || oldStack.func_77960_j() != newStack.func_77960_j();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidContainerItemWrapper((IFluidContainerItem)this, stack);
    }
}

