/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.xml;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.component.ItemStackRecipeComponent;
import org.cyclops.cyclopscore.recipe.xml.SuperRecipeTypeHandler;
import org.cyclops.cyclopscore.recipe.xml.XmlRecipeLoader;
import org.cyclops.evilcraft.block.BloodInfuser;
import org.cyclops.evilcraft.core.recipe.custom.DurationXpRecipeProperties;
import org.cyclops.evilcraft.core.recipe.custom.ItemFluidStackAndTierRecipeComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BloodInfuserRecipeTypeHandler
extends SuperRecipeTypeHandler<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> {
    public String getCategoryId() {
        return "evilcraft:bloodInfuserRecipe";
    }

    protected IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> handleRecipe(RecipeHandler recipeHandler, Element input, Element output, Element properties) throws XmlRecipeLoader.XmlRecipeException {
        Node inputItem = input.getElementsByTagName("item").item(0);
        Node outputItem = output.getElementsByTagName("item").item(0);
        int duration = Integer.parseInt(properties.getElementsByTagName("duration").item(0).getTextContent());
        int tier = 0;
        if (properties.getElementsByTagName("tier").getLength() > 0) {
            tier = Integer.parseInt(properties.getElementsByTagName("tier").item(0).getTextContent());
        }
        float xp = 0.0f;
        if (properties.getElementsByTagName("xp").getLength() > 0) {
            xp = Float.parseFloat(properties.getElementsByTagName("xp").item(0).getTextContent());
        }
        Object item = this.getItem(recipeHandler, inputItem);
        FluidStack fluidStack = this.getFluid(recipeHandler, input.getElementsByTagName("fluid").item(0));
        ItemFluidStackAndTierRecipeComponent recipeComponent = item instanceof ItemStack ? new ItemFluidStackAndTierRecipeComponent((ItemStack)item, fluidStack, tier) : new ItemFluidStackAndTierRecipeComponent((String)item, fluidStack, tier);
        ItemStack outputStack = (ItemStack)this.getItem(recipeHandler, outputItem);
        return BloodInfuser.getInstance().getRecipeRegistry().registerRecipe((IRecipeInput)recipeComponent, (IRecipeOutput)new ItemStackRecipeComponent(outputStack), (IRecipeProperties)new DurationXpRecipeProperties(duration, xp));
    }
}

