/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.tileentity.tickaction;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.evilcraft.core.tileentity.tickaction.ITickAction;

public class TickComponent<C extends CyclopsTileEntity, T extends ITickAction<C>> {
    private Multimap<Class<?>, T> tickActions;
    private C tile;
    private final boolean redstoneDisableable;
    private final boolean resetTickWhenCantTick;
    private int tick = 0;
    private float requiredTicks = 0.0f;
    private int slot;

    public TickComponent(C tile, Map<Class<?>, T> tickActions, int slot, boolean redstoneDisableable, boolean resetTickWhenCantTick) {
        this.tile = tile;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Map.Entry<Class<?>, T> entry : tickActions.entrySet()) {
            builder.put(entry);
        }
        this.tickActions = builder.build();
        this.slot = slot;
        this.redstoneDisableable = redstoneDisableable;
        this.resetTickWhenCantTick = resetTickWhenCantTick;
    }

    public TickComponent(C tile, Multimap<Class<?>, T> tickActions, int slot, boolean redstoneDisableable, boolean resetTickWhenCantTick) {
        this.tile = tile;
        this.tickActions = ImmutableMultimap.builder().putAll(tickActions).build();
        this.slot = slot;
        this.redstoneDisableable = redstoneDisableable;
        this.resetTickWhenCantTick = resetTickWhenCantTick;
    }

    public TickComponent(C tile, Map<Class<?>, T> tickActions, int slot) {
        this(tile, tickActions, slot, true, true);
    }

    public TickComponent(C tile, Multimap<Class<?>, T> tickActions, int slot) {
        this(tile, tickActions, slot, true, true);
    }

    public T getTickAction(Item item, int actionOffset) {
        for (Map.Entry entry : this.tickActions.entries()) {
            if (actionOffset-- != 0) continue;
            Item instance = item;
            if (((Class)entry.getKey()).isInstance(instance)) {
                return (T)((ITickAction)entry.getValue());
            }
            if (!(item instanceof ItemBlock)) continue;
            instance = ((ItemBlock)item).func_179223_d();
            if (!((Class)entry.getKey()).isInstance(instance)) continue;
            return (T)((ITickAction)entry.getValue());
        }
        return null;
    }

    public void tick(ItemStack itemStack, int slot) {
        if (itemStack != null) {
            C action;
            int actionOffset = 0;
            boolean ticked = false;
            while (!ticked && (action = this.getTickAction(itemStack.func_77973_b(), actionOffset++)) != null) {
                if (!action.canTick(this.tile, itemStack, slot, this.tick)) continue;
                ticked = true;
                if (this.tick == 0) {
                    this.requiredTicks = action.getRequiredTicks(this.tile, slot, this.tick);
                }
                ++this.tick;
                int repeatFor = this.requiredTicks == 0.0f ? 1 : Math.max(1, (int)Math.ceil(1.0f / this.requiredTicks));
                for (int i = 0; i < repeatFor; ++i) {
                    action.onTick(this.tile, itemStack, slot, this.tick);
                }
                if (!((float)this.tick >= this.requiredTicks)) continue;
                this.tick = 0;
            }
            if (!ticked && this.resetTickWhenCantTick) {
                this.tick = 0;
            }
        } else {
            this.tick = 0;
        }
    }

    public int getTick() {
        return this.tick;
    }

    public void setTick(int tick) {
        this.tick = tick;
    }

    public float getRequiredTicks() {
        return this.requiredTicks;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setRequiredTicks(float requiredTicks) {
        this.requiredTicks = requiredTicks;
    }

    public boolean isRedstoneDisableable() {
        return this.redstoneDisableable;
    }
}

