/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.event;

import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.cyclops.cyclopscore.helper.EnchantmentHelpers;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.enchantment.EnchantmentBreaking;
import org.cyclops.evilcraft.enchantment.EnchantmentBreakingConfig;
import org.cyclops.evilcraft.enchantment.EnchantmentUnusing;
import org.cyclops.evilcraft.enchantment.EnchantmentUnusingConfig;

public class PlayerInteractEventHook {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
        this.unusingEvent(event);
        this.breakingEvent(event);
    }

    private void unusingEvent(PlayerInteractEvent.LeftClickBlock event) {
        if (Configs.isEnabled(EnchantmentUnusingConfig.class) && this.doesEnchantApply(event, (Enchantment)EnchantmentUnusingConfig._instance.getEnchantment()) > -1 && event.getEntityPlayer() != null && EnchantmentUnusing.unuseTool(event.getEntityPlayer().func_184607_cu())) {
            event.setCanceled(true);
            event.getEntityPlayer().func_184597_cx();
        }
    }

    private void breakingEvent(PlayerInteractEvent.LeftClickBlock event) {
        if (Configs.isEnabled(EnchantmentBreakingConfig.class)) {
            int i = this.doesEnchantApply(event, (Enchantment)EnchantmentBreakingConfig._instance.getEnchantment());
            ItemStack itemStack = event.getEntityPlayer().func_184607_cu();
            EnchantmentBreaking.amplifyDamage(itemStack, i, new Random());
        }
    }

    private int doesEnchantApply(PlayerInteractEvent.LeftClickBlock event, Enchantment enchantment) {
        if (event.getEntityPlayer() != null) {
            ItemStack itemStack = event.getEntityPlayer().func_184607_cu();
            return EnchantmentHelpers.doesEnchantApply((ItemStack)itemStack, (Enchantment)enchantment);
        }
        return -1;
    }
}

