/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.Lists;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.Optional;
import org.cyclops.cyclopscore.config.configurable.ConfigurableDamageIndicatedItemFluidContainer;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.evilcraft.core.helper.obfuscation.ObfuscationHelpers;
import org.cyclops.evilcraft.fluid.Blood;
import org.cyclops.evilcraft.item.InvigoratingPendantConfig;
import org.cyclops.evilcraft.modcompat.baubles.BaublesModCompat;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles", striprefs=true)
public class InvigoratingPendant
extends ConfigurableDamageIndicatedItemFluidContainer
implements IBauble {
    private static final int TICK_MODULUS = 10;
    private static InvigoratingPendant _instance = null;

    public static InvigoratingPendant getInstance() {
        return _instance;
    }

    public InvigoratingPendant(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig, InvigoratingPendantConfig.capacity, (Fluid)Blood.getInstance());
        this.func_77625_d(1);
    }

    public void clearBadEffects(ItemStack itemStack, EntityPlayer player) {
        int amount = InvigoratingPendantConfig.usage;
        if (this.canConsume(amount, itemStack, player)) {
            int originalReducableDuration;
            int reducableDuration = originalReducableDuration = InvigoratingPendantConfig.reduceDuration * 20;
            Iterator it = Lists.newLinkedList((Iterable)player.func_70651_bq()).iterator();
            while (reducableDuration > 0 && it.hasNext() && this.canConsume(amount, itemStack, player)) {
                PotionEffect effect = (PotionEffect)it.next();
                Potion potion = effect.func_188419_a();
                boolean shouldClear = true;
                if (potion != null) {
                    shouldClear = ObfuscationHelpers.isPotionBadEffect(potion);
                }
                if (!(shouldClear &= !effect.func_82720_e())) continue;
                int reductionMultiplier = effect.func_76458_c() + 1;
                int reducableDurationForThisEffect = reducableDuration / reductionMultiplier;
                int remaining = effect.func_76459_b();
                int toReduce = Math.min(reducableDurationForThisEffect, remaining);
                int toDrain = amount;
                reducableDuration -= toReduce;
                if (remaining == toReduce) {
                    player.func_184589_d(potion);
                } else {
                    ObfuscationHelpers.setPotionEffectDuration(effect, remaining - toReduce);
                    ObfuscationHelpers.onChangedPotionEffect((EntityLivingBase)player, effect, true);
                    toDrain = (int)Math.ceil((double)(reductionMultiplier * amount) * ((double)toReduce / (double)originalReducableDuration));
                }
                this.consume(toDrain, itemStack, player);
            }
        }
        if (InvigoratingPendantConfig.fireUsage >= 0 && player.func_70027_ad() && this.canConsume(InvigoratingPendantConfig.fireUsage, itemStack, player)) {
            player.func_70066_B();
            this.consume(InvigoratingPendantConfig.fireUsage, itemStack, player);
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityPlayer && WorldHelpers.efficientTick((World)world, (int)10, (int[])new int[]{entity.func_145782_y()})) {
            this.clearBadEffects(itemStack, (EntityPlayer)entity);
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemStack, EntityLivingBase entity) {
        return BaublesModCompat.canUse();
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemStack, EntityLivingBase entity) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.AMULET;
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemStack, EntityLivingBase entity) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemStack, EntityLivingBase entity) {
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack itemStack, EntityLivingBase entity) {
        if (BaublesModCompat.canUse()) {
            this.func_77663_a(itemStack, entity.field_70170_p, (Entity)entity, 0, false);
        }
    }
}

