/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.client.particle.ParticleBlur;
import org.cyclops.cyclopscore.config.configurable.ConfigurableDamageIndicatedItemFluidContainer;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.entity.item.EntityItemUndespawnable;
import org.cyclops.evilcraft.fluid.Blood;
import org.cyclops.evilcraft.item.ItemPowerableHelpers;
import org.cyclops.evilcraft.item.KineticatorConfig;

public class Kineticator
extends ConfigurableDamageIndicatedItemFluidContainer {
    private static Kineticator _instance = null;
    private static final int POWER_LEVELS = 5;
    private static final int RANGE_PER_LEVEL = 2;
    private static final double USAGE_PER_D = 0.1;
    private static final int CONTAINER_SIZE = 1000;

    public static Kineticator getInstance() {
        return _instance;
    }

    public Kineticator(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig, 1000, (Fluid)Blood.getInstance());
        this.func_77627_a(true);
    }

    public boolean isRepelling(ItemStack itemStack) {
        return itemStack.func_77952_i() == 1;
    }

    protected void setRepelling(ItemStack itemStack, boolean repelling) {
        itemStack.func_77964_b(repelling ? 1 : 0);
    }

    private int getArea(ItemStack itemStack) {
        return 2 * (this.getPower(itemStack) + 1);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        if (!ItemPowerableHelpers.onPowerableItemItemRightClick(itemStack, world, player, 5, false) && !world.field_72995_K) {
            ItemHelpers.toggleActivation(itemStack);
        }
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        L10NHelpers.addStatusInfo((List)list, (boolean)ItemHelpers.isActivated(itemStack), (String)(this.func_77658_a() + ".info" + (this.isRepelling(itemStack) ? ".repelling" : "") + ".attraction"));
        list.add(TextFormatting.BOLD + L10NHelpers.localize((String)(this.func_77658_a() + ".info.area"), (Object[])new Object[]{this.getArea(itemStack)}));
    }

    public int getPower(ItemStack itemStack) {
        return ItemPowerableHelpers.getPower(itemStack);
    }

    public void setPower(ItemStack itemStack, int power) {
        ItemPowerableHelpers.setPower(itemStack, power);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityPlayer) {
            this.kineticate(itemStack, world, entity);
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        this.kineticate(entityItem.func_92059_d(), entityItem.field_70170_p, (Entity)entityItem);
        return super.onEntityItemUpdate(entityItem);
    }

    private void kineticate(ItemStack itemStack, World world, Entity entity) {
        if (ItemHelpers.isActivated(itemStack) && (this.getFluid(itemStack) != null || entity instanceof EntityPlayer && this.canConsume(1, itemStack, (EntityPlayer)entity)) && (entity != null || !entity.func_70093_af())) {
            boolean repelling = this.isRepelling(itemStack);
            boolean isPlayer = entity instanceof EntityPlayer;
            double x = entity.field_70165_t;
            double y = entity.field_70163_u;
            double z = entity.field_70161_v;
            if (0L == world.func_72820_D() % (long)KineticatorConfig.tickHoldoff) {
                int area = this.getArea(itemStack);
                AxisAlignedBB box = new AxisAlignedBB(x, y, z, x, y, z).func_72314_b((double)area, (double)area, (double)area);
                List entities = world.func_175674_a(entity, box, (Predicate)new Predicate<Entity>(){

                    public boolean apply(Entity entity) {
                        return entity instanceof EntityItem || KineticatorConfig.moveXP && entity instanceof EntityXPOrb;
                    }
                });
                for (Entity moveEntity : entities) {
                    if (!repelling && (!(moveEntity instanceof EntityItem) || ((EntityItem)moveEntity).func_174874_s() || !this.canKineticateItem(((EntityItem)moveEntity).func_92059_d())) && !(moveEntity instanceof EntityXPOrb)) continue;
                    double dx = moveEntity.field_70165_t - x;
                    double dy = moveEntity.field_70163_u - (isPlayer ? y + (double)(world.field_72995_K ? -1 : 1) : y);
                    double dz = moveEntity.field_70161_v - z;
                    double strength = -0.3;
                    if (isPlayer) {
                        strength = -1.0;
                    }
                    if (repelling) {
                        strength /= -1.0;
                        if (isPlayer) {
                            strength = 0.3;
                        }
                    }
                    double d = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
                    int usage = (int)Math.round(d * 0.1);
                    if (!repelling && !(d > 0.5) || usage != 0 && this.drain(itemStack, usage, false) == null && (!isPlayer || !this.canConsume(usage, itemStack, (EntityPlayer)entity))) continue;
                    double m = 1.0 / (2.0 * Math.max(1.0, d));
                    dx *= m;
                    dy *= m;
                    dz *= m;
                    if (world.field_72995_K) {
                        this.showEntityMoved(world, entity, moveEntity, dx / 10.0, dy / 10.0, dz / 10.0);
                    } else {
                        if (moveEntity instanceof EntityItem && d < 5.0) {
                            ((EntityItem)moveEntity).func_174867_a(repelling ? 5 : 0);
                        }
                        moveEntity.field_70159_w = dx * strength;
                        moveEntity.field_70181_x = dy * strength;
                        moveEntity.field_70179_y = dz * strength;
                        if (moveEntity.field_70123_F) {
                            moveEntity.field_70181_x = 0.3;
                        }
                    }
                    if (0L != world.func_72820_D() % (long)KineticatorConfig.consumeHoldoff) continue;
                    if (isPlayer) {
                        this.consume(usage, itemStack, (EntityPlayer)entity);
                        continue;
                    }
                    this.drain(itemStack, usage, true);
                }
            }
        }
    }

    protected boolean canKineticateItem(ItemStack entityItem) {
        if (entityItem == null) {
            return false;
        }
        for (String name : KineticatorConfig.kineticateBlacklist) {
            if (!((ResourceLocation)field_150901_e.func_177774_c((Object)entityItem.func_77973_b())).toString().equals(name)) continue;
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    protected void showEntityMoved(World world, Entity player, Entity entity, double dx, double dy, double dz) {
        Random rand = world.field_73012_v;
        float scale = 0.05f;
        float red = rand.nextFloat() * 0.03f + 0.5f;
        float green = rand.nextFloat() * 0.03f + (rand.nextBoolean() ? 0.5f : 0.3f);
        float blue = rand.nextFloat() * 0.05f;
        float ageMultiplier = (float)(rand.nextDouble() * 2.5 + 10.0);
        ParticleBlur blur = new ParticleBlur(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, scale, -dx, -dy, -dz, red, green, blue, ageMultiplier);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)blur);
    }

    public boolean hasCustomEntity(ItemStack itemStack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemStack) {
        return new EntityItemUndespawnable(world, (EntityItem)location);
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77658_a() + (this.isRepelling(itemStack) ? ".repelling" : "");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List itemList) {
        this.component.getSubItems(item, tab, itemList, this.fluid, 0);
        this.component.getSubItems(item, tab, itemList, this.fluid, 1);
    }
}

