/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.IChangedCallback;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.item.PrimedPendant;

public class PrimedPendantConfig
extends ItemConfig {
    private static final String DELIMITER = ":";
    public static PrimedPendantConfig _instance;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="The capacity of the pendant.", requiresMcRestart=true)
    public static int capacity;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="The amount of Blood to drain after one effect application.", isCommandable=true)
    public static int usage;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="Usage multipliers. Potion ids are first, followed by floating numbers. A number smaller than one blacklists that potion.", changedCallback=PotionMultipliersChanged.class)
    public static String[] potionMultipliers;
    private Map<Integer, Double> multipliers = Maps.newHashMap();

    public PrimedPendantConfig() {
        super((ModBase)EvilCraft._instance, true, "primedPendant", null, PrimedPendant.class);
    }

    public void registerFromConfig(String[] config) {
        this.multipliers.clear();
        for (String line : config) {
            String[] split = line.split(DELIMITER);
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid line '" + line + "' found for " + "a Primed Pendant potion multiplier config.");
            }
            try {
                int potionId = Integer.parseInt(split[0]);
                if (Potion.func_188412_a((int)potionId) == null) {
                    EvilCraft.clog("Invalid line '" + line + "' found for " + "a Primed Pendant potion multiplier config: " + split[0] + " does not refer to an existing potion; skipping.");
                }
                Potion potion = Potion.func_188412_a((int)potionId);
                double multiplier = 1.0;
                try {
                    multiplier = Double.parseDouble(split[1]);
                }
                catch (NumberFormatException e) {
                    EvilCraft.clog("Invalid ratio '" + split[1] + "' in " + "a Primed Pendant potion multiplier config, using 1.0.", Level.ERROR);
                }
                this.multipliers.put(Potion.func_188409_a((Potion)potion), multiplier);
            }
            catch (NumberFormatException e) {
                EvilCraft.clog("Invalid line '" + line + "' found for " + "a Primed Pendant potion multiplier config: " + split[0] + " is not a number; skipping.");
            }
        }
    }

    public Double getMultiplier(Potion potion) {
        return this.multipliers.get(Potion.func_188409_a((Potion)potion));
    }

    static {
        capacity = 5000;
        usage = 10;
        potionMultipliers = new String[]{Potion.func_188409_a((Potion)MobEffects.field_180152_w) + DELIMITER + "-1", Potion.func_188409_a((Potion)MobEffects.field_76428_l) + DELIMITER + "10"};
    }

    public static class PotionMultipliersChanged
    implements IChangedCallback {
        private static boolean calledOnce = false;

        public void onChanged(Object value) {
            if (calledOnce) {
                _instance.registerFromConfig((String[])value);
            }
            calledOnce = true;
        }

        public void onRegisteredPostInit(Object value) {
            this.onChanged(value);
        }
    }
}

