/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.ConfigurableItem;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.evilcraft.core.tileentity.WorkingTileEntity;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.lwjgl.input.Keyboard;

public class Promise
extends ConfigurableItem {
    private static Promise _instance = null;
    public static final Upgrades.Upgrade[] UPGRADES = new Upgrades.Upgrade[]{WorkingTileEntity.UPGRADE_TIER1, WorkingTileEntity.UPGRADE_TIER2, WorkingTileEntity.UPGRADE_TIER3, WorkingTileEntity.UPGRADE_SPEED, WorkingTileEntity.UPGRADE_EFFICIENCY};
    public static final Map<Upgrades.Upgrade, Integer> MAIN_COLORS = Maps.newHashMap();
    public static final Map<Upgrades.Upgrade, Integer> SECONDARY_COLORS = Maps.newHashMap();

    public static Promise getInstance() {
        return _instance;
    }

    public Promise(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig);
        this.func_77625_d(4);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public int getItemStackLimit(ItemStack itemStack) {
        if (itemStack.func_77952_i() <= 2) {
            return 1;
        }
        return super.getItemStackLimit(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        if (Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42)) {
            list.add(TextFormatting.DARK_GREEN + L10NHelpers.localize((String)(super.func_77667_c(itemStack) + ".useIn")));
            for (BlockConfig upgradable : this.getUpgrade(itemStack).getUpgradables()) {
                list.add(TextFormatting.ITALIC + L10NHelpers.localize((String)("tile." + upgradable.getUnlocalizedName() + ".name")));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < UPGRADES.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77667_c(itemStack) + "." + this.getUpgrade(itemStack).getId();
    }

    public Upgrades.Upgrade getUpgrade(ItemStack itemStack) {
        return UPGRADES[Math.min(UPGRADES.length - 1, itemStack.func_77952_i())];
    }

    public boolean isTierUpgrade(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77952_i() <= 2;
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return itemStack.func_77952_i() < 3 ? EnumRarity.RARE : EnumRarity.UNCOMMON;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColorHandler() {
        return new ItemColor();
    }

    static {
        MAIN_COLORS.put(WorkingTileEntity.UPGRADE_TIER1, Helpers.RGBToInt((int)220, (int)220, (int)220));
        SECONDARY_COLORS.put(WorkingTileEntity.UPGRADE_TIER1, Helpers.RGBToInt((int)255, (int)255, (int)255));
        MAIN_COLORS.put(WorkingTileEntity.UPGRADE_TIER2, Helpers.RGBToInt((int)234, (int)238, (int)87));
        SECONDARY_COLORS.put(WorkingTileEntity.UPGRADE_TIER2, Helpers.RGBToInt((int)230, (int)230, (int)160));
        MAIN_COLORS.put(WorkingTileEntity.UPGRADE_TIER3, Helpers.RGBToInt((int)51, (int)235, (int)203));
        SECONDARY_COLORS.put(WorkingTileEntity.UPGRADE_TIER3, Helpers.RGBToInt((int)150, (int)250, (int)200));
        MAIN_COLORS.put(WorkingTileEntity.UPGRADE_SPEED, Helpers.RGBToInt((int)200, (int)90, (int)80));
        SECONDARY_COLORS.put(WorkingTileEntity.UPGRADE_SPEED, Helpers.RGBToInt((int)240, (int)120, (int)110));
        MAIN_COLORS.put(WorkingTileEntity.UPGRADE_EFFICIENCY, Helpers.RGBToInt((int)80, (int)70, (int)200));
        SECONDARY_COLORS.put(WorkingTileEntity.UPGRADE_EFFICIENCY, Helpers.RGBToInt((int)120, (int)120, (int)210));
    }

    @SideOnly(value=Side.CLIENT)
    public static class ItemColor
    implements IItemColor {
        public int func_186726_a(ItemStack itemStack, int renderPass) {
            Upgrades.Upgrade upgrade = Promise.getInstance().getUpgrade(itemStack);
            return renderPass == 0 ? SECONDARY_COLORS.get(upgrade) : MAIN_COLORS.get(upgrade);
        }
    }
}

