/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.ConfigurableItem;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class ResurgenceEgg
extends ConfigurableItem {
    private static final String NBTKEY_ENTITY = "innerEntity";
    private static ResurgenceEgg _instance = null;

    public static ResurgenceEgg getInstance() {
        return _instance;
    }

    public ResurgenceEgg(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig);
        this.func_77625_d(1);
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return !this.isEmpty(itemStack);
    }

    public String getEntityString(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag != null) {
            return tag.func_74779_i(NBTKEY_ENTITY);
        }
        return null;
    }

    public boolean isEmpty(ItemStack itemStack) {
        return this.getEntityString(itemStack) == null;
    }

    public void setEntity(ItemStack itemStack, String entityString) {
        NBTTagCompound tag = itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
        tag.func_74778_a(NBTKEY_ENTITY, entityString);
        itemStack.func_77982_d(tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        String content = TextFormatting.ITALIC + L10NHelpers.localize((String)"general.info.empty");
        String id = this.getEntityString(itemStack);
        if (id != null) {
            content = L10NHelpers.getLocalizedEntityName((String)id);
        }
        list.add(TextFormatting.BOLD + L10NHelpers.localize((String)(this.func_77658_a() + ".info.content"), (Object[])new Object[]{TextFormatting.RESET + content}));
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
        }
        RayTraceResult movingobjectposition = this.func_77621_a(world, player, true);
        if (movingobjectposition == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
        }
        if (movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK) {
            Entity entity;
            BlockPos blockPos = movingobjectposition.func_178782_a();
            int x = blockPos.func_177958_n();
            int y = blockPos.func_177956_o();
            int z = blockPos.func_177952_p();
            if (!world.canMineBlockBody(player, blockPos)) {
                return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
            }
            if (world.func_180495_p(blockPos).func_177230_c() instanceof BlockLiquid && (entity = ResurgenceEgg.spawnCreature(world, this.getEntityString(itemStack), x, y, z)) != null) {
                if (entity instanceof EntityLivingBase && itemStack.func_82837_s()) {
                    entity.func_96094_a(itemStack.func_82833_r());
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    --itemStack.field_77994_a;
                }
            }
        }
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    public static Entity spawnCreature(World world, String entityString, double x, double y, double z) {
        Entity entity = EntityList.func_75620_a((String)entityString, (World)world);
        if (entity != null && entity instanceof EntityLivingBase) {
            EntityLiving entityliving = (EntityLiving)entity;
            entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            entityliving.field_70759_as = entityliving.field_70177_z;
            entityliving.field_70761_aq = entityliving.field_70177_z;
            world.func_72838_d(entity);
            entityliving.func_70642_aH();
        }
        return entity;
    }
}

