/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.modcompat.jei.bloodinfuser;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.component.ItemStackRecipeComponent;
import org.cyclops.evilcraft.block.BloodInfuser;
import org.cyclops.evilcraft.core.recipe.custom.DurationXpRecipeProperties;
import org.cyclops.evilcraft.core.recipe.custom.ItemFluidStackAndTierRecipeComponent;

public class BloodInfuserRecipeJEI
extends BlankRecipeWrapper {
    private final IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> recipe;
    private final FluidStack fluidStack;
    private final int upgrade;
    private final List<ItemStack> input;
    private final List<ItemStack> output;
    private final String xpString;

    public BloodInfuserRecipeJEI(IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> recipe) {
        this.recipe = recipe;
        this.fluidStack = ((ItemFluidStackAndTierRecipeComponent)recipe.getInput()).getFluidStack();
        this.upgrade = ((ItemFluidStackAndTierRecipeComponent)recipe.getInput()).getTier();
        this.input = ((ItemFluidStackAndTierRecipeComponent)recipe.getInput()).getItemStacks();
        this.output = ((ItemStackRecipeComponent)recipe.getOutput()).getItemStacks();
        this.xpString = Translator.translateToLocalFormatted((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(((DurationXpRecipeProperties)recipe.getProperties()).getXp())});
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.getInputs());
        ingredients.setOutputs(ItemStack.class, this.getOutputs());
        ingredients.setInputs(FluidStack.class, this.getFluidInputs());
    }

    public List getInputs() {
        return this.input;
    }

    public List getOutputs() {
        return this.output;
    }

    public List<FluidStack> getFluidInputs() {
        return Lists.newArrayList((Object[])new FluidStack[]{this.fluidStack});
    }

    public static List<BloodInfuserRecipeJEI> getAllRecipes() {
        return Lists.transform((List)BloodInfuser.getInstance().getRecipeRegistry().allRecipes(), (Function)new Function<IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties>, BloodInfuserRecipeJEI>(){

            @Nullable
            public BloodInfuserRecipeJEI apply(IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> input) {
                return new BloodInfuserRecipeJEI(input);
            }
        });
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        FontRenderer fontRendererObj = minecraft.field_71466_p;
        fontRendererObj.func_78276_b(this.xpString, 100 - fontRendererObj.func_78256_a(this.xpString) / 2, 5, Color.gray.getRGB());
    }

    public boolean equals(Object o) {
        return o instanceof BloodInfuserRecipeJEI && ((BloodInfuserRecipeJEI)((Object)o)).recipe.equals(this.recipe);
    }

    public int hashCode() {
        return 1 | this.recipe.hashCode();
    }

    public IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> getRecipe() {
        return this.recipe;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public int getUpgrade() {
        return this.upgrade;
    }

    public List<ItemStack> getInput() {
        return this.input;
    }

    public List<ItemStack> getOutput() {
        return this.output;
    }

    public String getXpString() {
        return this.xpString;
    }

    public String toString() {
        return "BloodInfuserRecipeJEI(recipe=" + this.getRecipe() + ", fluidStack=" + this.getFluidStack() + ", upgrade=" + this.getUpgrade() + ", input=" + this.getInput() + ", output=" + this.getOutput() + ", xpString=" + this.getXpString() + ")";
    }
}

