/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.modcompat.jei.environmentalaccumulator;

import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.evilcraft.block.EnvironmentalAccumulator;
import org.cyclops.evilcraft.modcompat.jei.environmentalaccumulator.CommonEnvironmentalAccumulatorRecipeCategory;
import org.cyclops.evilcraft.modcompat.jei.environmentalaccumulator.EnvironmentalAccumulatorRecipeJEIBase;

public class EnvironmentalAccumulatorRecipeCategory
extends CommonEnvironmentalAccumulatorRecipeCategory {
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private final IDrawable background;
    private final IDrawableAnimated arrow;

    public EnvironmentalAccumulatorRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, (Pair<Integer, Integer>)Pair.of((Object)2, (Object)8), (Pair<Integer, Integer>)Pair.of((Object)76, (Object)8));
        ResourceLocation resourceLocation = new ResourceLocation("evilcraft:" + EnvironmentalAccumulator.getInstance().getGuiTexture("_jei"));
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 94, 54);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(resourceLocation, 94, 0, 5, 34);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    @Nonnull
    public String getUid() {
        return "evilcraft:environmentalAccumulator";
    }

    @Nonnull
    public String getTitle() {
        return L10NHelpers.localize((String)(EnvironmentalAccumulator.getInstance().func_149739_a() + ".name"));
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public void drawExtras(Minecraft minecraft) {
        super.drawExtras(minecraft);
        this.arrow.draw(minecraft, 44, 0);
    }

    @Override
    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        super.setRecipe(recipeLayout, recipeWrapper);
        recipeLayout.getItemStacks().init(0, true, 1, 27);
        recipeLayout.getItemStacks().init(1, false, 75, 27);
        if (recipeWrapper instanceof EnvironmentalAccumulatorRecipeJEIBase) {
            EnvironmentalAccumulatorRecipeJEIBase recipe = (EnvironmentalAccumulatorRecipeJEIBase)recipeWrapper;
            recipeLayout.getItemStacks().set(0, recipe.getInput());
            recipeLayout.getItemStacks().set(1, recipe.getOutput());
        }
    }
}

