/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;

public class TileEternalWaterBlock
extends CyclopsTileEntity
implements CyclopsTileEntity.ITickingTile {
    public static final FluidStack WATER = new FluidStack(FluidRegistry.WATER, 1000);
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);

    public TileEternalWaterBlock() {
        this.addCapabilityInternal(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, new InfiniteWaterFluidCapability());
    }

    protected void updateTileEntity() {
        if (!this.func_145831_w().field_72995_K) {
            for (EnumFacing direction : EnumFacing.field_82609_l) {
                IFluidHandler handler = (IFluidHandler)TileHelpers.getCapability((World)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177972_a(direction), (EnumFacing)direction.func_176734_d(), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
                if (handler == null) continue;
                FluidStack fluidStack = new FluidStack(FluidRegistry.WATER, 1000);
                handler.fill(fluidStack, true);
            }
        }
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }

    public static class InfiniteWaterFluidCapability
    implements IFluidHandler {
        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new FluidTankProperties(WATER, 0)};
        }

        public int fill(FluidStack resource, boolean doFill) {
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null || resource.getFluid() != WATER.getFluid()) {
                return null;
            }
            return new FluidStack(WATER.getFluid(), Math.min(resource.amount, TileEternalWaterBlock.WATER.amount));
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return new FluidStack(WATER.getFluid(), Math.min(maxDrain, TileEternalWaterBlock.WATER.amount));
        }
    }
}

