/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import java.util.LinkedList;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEnchantmentTable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.cyclopscore.tileentity.TankInventoryTileEntity;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.api.tileentity.purifier.IPurifierActionRegistry;
import org.cyclops.evilcraft.block.Purifier;
import org.cyclops.evilcraft.block.PurifierConfig;
import org.cyclops.evilcraft.client.particle.ParticleBloodBubble;
import org.cyclops.evilcraft.client.particle.ParticleMagicFinish;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;
import org.cyclops.evilcraft.fluid.Blood;

public class TilePurifier
extends TankInventoryTileEntity
implements CyclopsTileEntity.ITickingTile {
    public static final int SLOTS = 2;
    public static final int SLOT_PURIFY = 0;
    public static final int SLOT_ADDITIONAL = 1;
    private static final int ANIMATION_FINISHED_DURATION = 2;
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    @NBTPersist
    private Float randomRotation = Float.valueOf(0.0f);
    private int tick = 0;
    public static final Fluid FLUID = Blood.getInstance();
    private static final int MAX_BUCKETS = 3;
    @NBTPersist
    public Integer tickCount = 0;
    @NBTPersist
    public Float additionalRotation2 = Float.valueOf(0.0f);
    @NBTPersist
    public Float additionalRotationPrev = Float.valueOf(0.0f);
    @NBTPersist
    public Float additionalRotation = Float.valueOf(0.0f);
    @NBTPersist
    private Integer finishedAnimation = 0;
    @NBTPersist
    private Integer currentAction = -1;

    public TilePurifier() {
        super(2, PurifierConfig._instance.getNamedId(), 1, 3000, PurifierConfig._instance.getNamedId() + "tank", FLUID);
        LinkedList<Integer> slots = new LinkedList<Integer>();
        slots.add(1);
        slots.add(0);
        for (EnumFacing direction : DirectionHelpers.DIRECTIONS) {
            this.addSlotsToSide(direction, slots);
        }
        this.setSendUpdateOnInventoryChanged(true);
        this.setSendUpdateOnTankChanged(true);
    }

    protected SingleUseTank newTank(String tankName, int tankSize) {
        return new ImplicitFluidConversionTank(tankName, tankSize, (CyclopsTileEntity)this, BloodFluidConverter.getInstance());
    }

    public IPurifierActionRegistry getActions() {
        return (IPurifierActionRegistry)EvilCraft._instance.getRegistryManager().getRegistry(IPurifierActionRegistry.class);
    }

    public void updateTileEntity() {
        super.updateTileEntity();
        int actionId = this.currentAction;
        if (actionId < 0) {
            actionId = this.getActions().canWork(this);
        }
        if (actionId >= 0) {
            ++this.tick;
            if (this.getActions().work(actionId, this)) {
                this.tick = 0;
                this.currentAction = -1;
                this.onActionFinished();
            }
        } else {
            this.tick = 0;
            this.currentAction = -1;
        }
        if (this.finishedAnimation > 0) {
            Integer n = this.finishedAnimation;
            Integer n2 = this.finishedAnimation = Integer.valueOf(this.finishedAnimation - 1);
            if (this.field_145850_b.field_72995_K) {
                this.showEnchantedEffect();
            }
        }
        this.updateAdditionalItem();
    }

    public void onActionFinished() {
        this.finishedAnimation = 2;
    }

    public int getBucketsFloored() {
        return (int)Math.floor((double)this.getTank().getFluidAmount() / 1000.0);
    }

    public int getBucketsRest() {
        return this.getTank().getFluidAmount() % 1000;
    }

    public void setBuckets(int buckets, int rest) {
        this.getTank().setFluid(new FluidStack(FLUID, 1000 * buckets + rest));
        this.sendUpdate();
    }

    public int getMaxBuckets() {
        return 3;
    }

    protected void onSendUpdate() {
        super.onSendUpdate();
        this.field_145850_b.func_180501_a(this.func_174877_v(), Purifier.getInstance().func_176223_P().func_177226_a((IProperty)Purifier.FILL, (Comparable)Integer.valueOf(this.getBucketsFloored())), 2);
    }

    private void updateAdditionalItem() {
        float baseNextRotation;
        this.additionalRotationPrev = this.additionalRotation2;
        TilePurifier tilePurifier = this;
        tilePurifier.additionalRotation = Float.valueOf(tilePurifier.additionalRotation.floatValue() + 0.02f);
        while (this.additionalRotation2.floatValue() >= (float)Math.PI) {
            tilePurifier = this;
            Float.valueOf(tilePurifier.additionalRotation2.floatValue() - (float)Math.PI * 2);
            tilePurifier.additionalRotation2 = tilePurifier.additionalRotation2;
        }
        while (this.additionalRotation2.floatValue() < (float)(-Math.PI)) {
            tilePurifier = this;
            Float.valueOf(tilePurifier.additionalRotation2.floatValue() + (float)Math.PI * 2);
            tilePurifier.additionalRotation2 = tilePurifier.additionalRotation2;
        }
        while (this.additionalRotation.floatValue() >= (float)Math.PI) {
            tilePurifier = this;
            Float.valueOf(tilePurifier.additionalRotation.floatValue() - (float)Math.PI * 2);
            tilePurifier.additionalRotation = tilePurifier.additionalRotation;
        }
        while (this.additionalRotation.floatValue() < (float)(-Math.PI)) {
            tilePurifier = this;
            Float.valueOf(tilePurifier.additionalRotation.floatValue() + (float)Math.PI * 2);
            tilePurifier.additionalRotation = tilePurifier.additionalRotation;
        }
        for (baseNextRotation = this.additionalRotation.floatValue() - this.additionalRotation2.floatValue(); baseNextRotation >= (float)Math.PI; baseNextRotation -= (float)Math.PI * 2) {
        }
        while (baseNextRotation < (float)(-Math.PI)) {
            baseNextRotation += (float)Math.PI * 2;
        }
        TilePurifier tilePurifier2 = this;
        tilePurifier2.additionalRotation2 = Float.valueOf(tilePurifier2.additionalRotation2.floatValue() + baseNextRotation * 0.4f);
        tilePurifier2 = this;
        tilePurifier2.tickCount = tilePurifier2.tickCount + 1;
    }

    public ItemStack getPurifyItem() {
        return this.func_70301_a(0);
    }

    public void setPurifyItem(ItemStack itemStack) {
        this.randomRotation = Float.valueOf(this.field_145850_b.field_73012_v.nextFloat() * 360.0f);
        this.func_70299_a(0, itemStack);
    }

    public ItemStack getAdditionalItem() {
        return this.func_70301_a(1);
    }

    public void setAdditionalItem(ItemStack itemStack) {
        this.func_70299_a(1, itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void showEffect() {
        for (int i = 0; i < 1; ++i) {
            double particleX = (double)this.func_174877_v().func_177958_n() + 0.2 + this.field_145850_b.field_73012_v.nextDouble() * 0.6;
            double particleY = (double)this.func_174877_v().func_177956_o() + 0.2 + this.field_145850_b.field_73012_v.nextDouble() * 0.6;
            double particleZ = (double)this.func_174877_v().func_177952_p() + 0.2 + this.field_145850_b.field_73012_v.nextDouble() * 0.6;
            float particleMotionX = -0.01f + this.field_145850_b.field_73012_v.nextFloat() * 0.02f;
            float particleMotionY = 0.01f;
            float particleMotionZ = -0.01f + this.field_145850_b.field_73012_v.nextFloat() * 0.02f;
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)new ParticleBloodBubble(this.field_145850_b, particleX, particleY, particleZ, particleMotionX, particleMotionY, particleMotionZ));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void showEnchantingEffect() {
        if (this.field_145850_b.field_73012_v.nextInt(10) == 0) {
            for (int i = 0; i < 1; ++i) {
                double particleX = (double)this.func_174877_v().func_177958_n() + 0.45 + this.field_145850_b.field_73012_v.nextDouble() * 0.1;
                double particleY = (double)this.func_174877_v().func_177956_o() + 1.45 + this.field_145850_b.field_73012_v.nextDouble() * 0.1;
                double particleZ = (double)this.func_174877_v().func_177952_p() + 0.45 + this.field_145850_b.field_73012_v.nextDouble() * 0.1;
                float particleMotionX = -0.4f + this.field_145850_b.field_73012_v.nextFloat() * 0.8f;
                float particleMotionY = -this.field_145850_b.field_73012_v.nextFloat();
                float particleMotionZ = -0.4f + this.field_145850_b.field_73012_v.nextFloat() * 0.8f;
                FMLClientHandler.instance().getClient().field_71452_i.func_78873_a(new ParticleEnchantmentTable.EnchantmentTable().func_178902_a(0, this.field_145850_b, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ, new int[0]));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void showEnchantedEffect() {
        for (int i = 0; i < 100; ++i) {
            double particleX = (double)this.func_174877_v().func_177958_n() + 0.45 + this.field_145850_b.field_73012_v.nextDouble() * 0.1;
            double particleY = (double)this.func_174877_v().func_177956_o() + 1.45 + this.field_145850_b.field_73012_v.nextDouble() * 0.1;
            double particleZ = (double)this.func_174877_v().func_177952_p() + 0.45 + this.field_145850_b.field_73012_v.nextDouble() * 0.1;
            float particleMotionX = -0.4f + this.field_145850_b.field_73012_v.nextFloat() * 0.8f;
            float particleMotionY = -0.4f + this.field_145850_b.field_73012_v.nextFloat() * 0.8f;
            float particleMotionZ = -0.4f + this.field_145850_b.field_73012_v.nextFloat() * 0.8f;
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)new ParticleMagicFinish(this.field_145850_b, particleX, particleY, particleZ, particleMotionX, particleMotionY, particleMotionZ));
        }
    }

    public float getRandomRotation() {
        return this.randomRotation.floatValue();
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (i == 0) {
            return itemStack.field_77994_a == 1 && this.getActions().isItemValidForMainSlot(itemStack);
        }
        if (i == 1) {
            return itemStack.field_77994_a == 1 && this.getActions().isItemValidForAdditionalSlot(itemStack);
        }
        return false;
    }

    public int getTick() {
        return this.tick;
    }

    public Integer getCurrentAction() {
        return this.currentAction;
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

