/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity;

import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.cyclopscore.tileentity.TankInventoryTileEntity;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.block.BloodStainedBlock;
import org.cyclops.evilcraft.block.PurifierConfig;
import org.cyclops.evilcraft.block.SanguinaryPedestalConfig;
import org.cyclops.evilcraft.core.algorithm.RegionIterator;
import org.cyclops.evilcraft.fluid.Blood;
import org.cyclops.evilcraft.network.packet.SanguinaryPedestalBlockReplacePacket;

public class TileSanguinaryPedestal
extends TankInventoryTileEntity
implements CyclopsTileEntity.ITickingTile {
    public static final Fluid FLUID = Blood.getInstance();
    private static final int MB_RATE = 100;
    private static final int TANK_BUCKETS = 10;
    private static final int OFFSET = 2;
    private static final int OFFSET_EFFICIENCY = 4;
    private static final int ACTIONS_PER_TICK_EFFICIENCY = 5;
    private final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    private RegionIterator regionIterator;

    public TileSanguinaryPedestal() {
        super(0, PurifierConfig._instance.getNamedId(), 1, 10000, SanguinaryPedestalConfig._instance.getNamedId() + "tank", FLUID);
    }

    public void fillWithPotentialBonus(FluidStack fluidStack) {
        if (this.hasEfficiency() && fluidStack != null) {
            fluidStack.amount = (int)((double)fluidStack.amount * SanguinaryPedestalConfig.efficiencyBoost);
        }
        this.fill(fluidStack, true);
    }

    protected void afterBlockReplace(World world, BlockPos location, Block block, int amount) {
        if (!this.getTank().isFull()) {
            this.fillWithPotentialBonus(new FluidStack(FLUID, amount));
        }
        EvilCraft._instance.getPacketHandler().sendToAllAround((PacketBase)new SanguinaryPedestalBlockReplacePacket(location, block), LocationHelpers.createTargetPointFromLocation((World)world, (BlockPos)location, (int)15));
    }

    protected boolean hasEfficiency() {
        return this.func_145832_p() == 1;
    }

    public void updateTileEntity() {
        super.updateTileEntity();
        if (!this.func_145831_w().field_72995_K) {
            int actions;
            int n = actions = this.hasEfficiency() ? 5 : 1;
            while (!this.getTank().isFull() && actions > 0) {
                BlockPos location = this.getNextLocation();
                Block block = this.func_145831_w().func_180495_p(location).func_177230_c();
                if (block == BloodStainedBlock.getInstance()) {
                    BloodStainedBlock.UnstainResult result = BloodStainedBlock.getInstance().unstainBlock(this.func_145831_w(), location, this.getTank().getCapacity() - this.getTank().getFluidAmount());
                    if (result.amount > 0) {
                        this.afterBlockReplace(this.func_145831_w(), location, result.block.func_177230_c(), result.amount);
                    }
                }
                --actions;
            }
            if (!this.getTank().isEmpty()) {
                for (EnumFacing direction : EnumFacing.field_82609_l) {
                    FluidStack fluidStack;
                    IFluidHandler handler = (IFluidHandler)TileHelpers.getCapability((World)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177972_a(direction), (EnumFacing)direction.func_176734_d(), (Capability)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
                    if (this.getTank().isEmpty() || handler == null || handler.fill(fluidStack = new FluidStack(this.getTank().getFluidType(), Math.min(100, this.getTank().getFluidAmount())), false) <= 0) continue;
                    int filled = handler.fill(fluidStack, true);
                    this.drain(filled, true);
                }
            }
        }
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    private BlockPos getNextLocation() {
        if (this.regionIterator == null) {
            this.regionIterator = new RegionIterator(this.func_174877_v(), this.hasEfficiency() ? 4 : 2, true);
        }
        return this.regionIterator.next();
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

