/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity.tickaction.bloodinfuser;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableInt;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.evilcraft.core.fluid.FluidContainerItemWrapperWithSimulation;
import org.cyclops.evilcraft.core.tileentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.tileentity.upgrade.Upgrades;
import org.cyclops.evilcraft.tileentity.TileBloodInfuser;
import org.cyclops.evilcraft.tileentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.tileentity.tickaction.bloodinfuser.BloodInfuserTickAction;

public class FluidContainerItemTickAction
extends BloodInfuserTickAction {
    @Override
    public boolean canTick(TileBloodInfuser tile, ItemStack itemStack, int slot, int tick) {
        return super.canTick(tile, itemStack, slot, tick) && FluidUtil.getFluidHandler((ItemStack)itemStack) != null;
    }

    @Override
    public void onTick(TileBloodInfuser tile, ItemStack itemStack, int slot, int tick) {
        ItemStack infuseStack = this.getInfuseStack(tile);
        if (infuseStack != null) {
            infuseStack = infuseStack.func_77946_l();
        }
        IFluidHandler container = FluidUtil.getFluidHandler((ItemStack)infuseStack);
        FluidStack fluidStack = tile.getTank().getFluid().copy();
        MutableInt duration = new MutableInt(100);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(duration, TileBloodInfuser.UPGRADEEVENT_FILLBLOODPERTICK));
        int minAmount = duration.getValue();
        fluidStack.amount = Math.min(minAmount, fluidStack.amount);
        int filled = container.fill(fluidStack, true);
        if (filled > 0) {
            tile.getTank().drain(filled, true);
            tile.getInventory().func_70299_a(tile.getConsumeSlot(), infuseStack);
            if (FluidHelpers.getFluid((IFluidHandler)container) != null && FluidHelpers.getAmount((FluidStack)FluidHelpers.getFluid((IFluidHandler)container)) == FluidHelpers.getCapacity((IFluidHandler)container) && this.addToProduceSlot(tile, infuseStack)) {
                tile.getInventory().func_70298_a(tile.getConsumeSlot(), 1);
            }
        } else {
            ItemStack result = FluidUtil.tryFillContainer((ItemStack)infuseStack, (IFluidHandler)tile.getTank(), (int)Integer.MAX_VALUE, null, (boolean)true);
            if (this.addToProduceSlot(tile, result)) {
                tile.getInventory().func_70298_a(tile.getConsumeSlot(), 1);
            }
        }
    }

    @Override
    public int getUnmodifiedRequiredTicks(TileBloodInfuser tile, int slot) {
        return EmptyFluidContainerInTankTickAction.getRequiredTicks(tile, this.getInfuseStack(tile));
    }

    @Override
    public ItemStack willProduceItem(TileBloodInfuser tile) {
        ItemStack itemStack = tile.getInventory().func_70301_a(tile.getConsumeSlot());
        if (itemStack == null) {
            return null;
        }
        if (FluidUtil.getFluidHandler((ItemStack)itemStack) instanceof FluidContainerItemWrapperWithSimulation) {
            return null;
        }
        ItemStack smallContainer = FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)tile.getTank(), (int)100, null, (boolean)false);
        if (smallContainer != null) {
            return smallContainer;
        }
        return FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)tile.getTank(), (int)1000, null, (boolean)false);
    }
}

