/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.tileentity.tickaction.purifier;

import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import org.cyclops.evilcraft.api.tileentity.purifier.IPurifierAction;
import org.cyclops.evilcraft.tileentity.TilePurifier;

public class CollectPotionPurifyAction
implements IPurifierAction {
    public static final Item ALLOWED_ITEM = Items.field_151069_bo;
    private static final int PURIFY_DURATION = 60;

    @Override
    public boolean isItemValidForMainSlot(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean isItemValidForAdditionalSlot(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() == ALLOWED_ITEM;
    }

    @Override
    public boolean canWork(TilePurifier tile) {
        if (tile.getPurifyItem() == null && tile.getAdditionalItem() != null && tile.getAdditionalItem().func_77973_b() == ALLOWED_ITEM && tile.getBucketsFloored() == tile.getMaxBuckets()) {
            List entities = tile.func_145831_w().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(tile.func_174877_v(), tile.func_174877_v().func_177982_a(1, 2, 1)));
            for (EntityLivingBase entity : entities) {
                for (PotionEffect potionEffect : entity.func_70651_bq()) {
                    if (potionEffect.func_82720_e()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean work(TilePurifier tile) {
        World world = tile.func_145831_w();
        int tick = tile.getTick();
        if (tile.getPurifyItem() == null && tile.getAdditionalItem() != null && tile.getAdditionalItem().func_77973_b() == ALLOWED_ITEM && tile.getBucketsFloored() == tile.getMaxBuckets()) {
            List entities = tile.func_145831_w().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(tile.func_174877_v(), tile.func_174877_v().func_177982_a(1, 2, 1)));
            for (EntityLivingBase entity : entities) {
                if (entity.func_70651_bq().isEmpty()) continue;
                if (tick >= 60 && !world.field_72995_K) {
                    for (PotionEffect potionEffect : entity.func_70651_bq()) {
                        if (potionEffect.func_82720_e()) continue;
                        entity.func_184589_d(potionEffect.func_188419_a());
                        ItemStack itemStack = new ItemStack((Item)Items.field_151068_bn);
                        NBTTagCompound tag = new NBTTagCompound();
                        NBTTagList tagList = new NBTTagList();
                        NBTTagCompound potionTag = new NBTTagCompound();
                        itemStack.func_77982_d(tag);
                        potionEffect.func_82719_a(potionTag);
                        tagList.func_74742_a((NBTBase)potionTag);
                        tag.func_74782_a("CustomPotionEffects", (NBTBase)tagList);
                        tile.setBuckets(0, 0);
                        tile.setAdditionalItem(itemStack);
                        return true;
                    }
                }
                if (!world.field_72995_K) continue;
                tile.showEffect();
            }
        }
        return false;
    }
}

